"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SlosView = SlosView;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _action_modal = require("../../../context/action_modal");
var _slo_list_card_view = require("./card_view/slo_list_card_view");
var _slo_list_compact_view = require("./compact_view/slo_list_compact_view");
var _health_callout = require("./health_callout/health_callout");
var _slo_list_empty = require("./slo_list_empty");
var _slo_list_error = require("./slo_list_error");
var _slo_list_view = require("./slo_list_view/slo_list_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/slos_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SlosView({
  sloList,
  loading,
  error,
  view
}) {
  if (!loading && !error && sloList.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_empty.SloListEmpty, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 12
      }
    });
  }
  if (!loading && error) {
    return /*#__PURE__*/_react.default.createElement(_slo_list_error.SloListError, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 12
      }
    });
  }
  if (view === 'cardView') {
    return /*#__PURE__*/_react.default.createElement(Wrapper, {
      sloList: sloList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_slo_list_card_view.SloListCardView, {
      sloList: sloList,
      loading: loading,
      error: error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }));
  }
  if (view === 'compactView') {
    return /*#__PURE__*/_react.default.createElement(Wrapper, {
      sloList: sloList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_slo_list_compact_view.SloListCompactView, {
      sloList: sloList,
      loading: loading,
      error: error,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    sloList: sloList,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_list_view.SloListView, {
    sloList: sloList,
    loading: loading,
    error: error,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }));
}
function Wrapper({
  children,
  sloList
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_health_callout.HealthCallout, {
    sloList: sloList,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_action_modal.ActionModalProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, children)));
}