"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloCardChart = SloCardChart;
exports.SloCardItem = SloCardItem;
exports.useSloCardColor = exports.getSubTitle = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/presentation-util-plugin/public");
var _sloSchema = require("@kbn/slo-schema");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _chart_data_formatter = require("../../../../utils/slo/chart_data_formatter");
var _use_slo_list_actions = require("../../hooks/use_slo_list_actions");
var _use_slo_summary = require("../../hooks/use_slo_summary");
var _burn_rate_rule_flyout = require("../common/burn_rate_rule_flyout");
var _edit_burn_rate_rule_flyout = require("../common/edit_burn_rate_rule_flyout");
var _slo_card_item_actions = require("./slo_card_item_actions");
var _slo_card_item_badges = require("./slo_card_item_badges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/card_view/slo_card_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SavedObjectSaveModalDashboard = (0, _public.withSuspense)(_public.LazySavedObjectSaveModalDashboard);
const useSloCardColor = status => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const colors = {
    DEGRADING: euiTheme.colors.backgroundBaseWarning,
    VIOLATED: euiTheme.colors.backgroundBaseDanger,
    HEALTHY: euiTheme.colors.backgroundBaseSuccess,
    NO_DATA: euiTheme.colors.backgroundBaseSubdued
  };
  return {
    cardColor: colors[status !== null && status !== void 0 ? status : 'NO_DATA'],
    colors
  };
};
exports.useSloCardColor = useSloCardColor;
const getSubTitle = slo => {
  return getFirstGroupBy(slo);
};
exports.getSubTitle = getSubTitle;
const getFirstGroupBy = slo => {
  const firstGroupBy = Object.entries(slo.groupings).map(([key, value]) => `${key}: ${value}`)[0];
  return slo.groupBy && ![slo.groupBy].flat().includes(_sloSchema.ALL_VALUE) ? firstGroupBy : '';
};
function SloCardItem({
  slo,
  rules,
  activeAlerts,
  historicalSummary,
  refetchRules
}) {
  const containerRef = _react2.default.useRef(null);
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react2.useState)(false);
  const [isAddRuleFlyoutOpen, setIsAddRuleFlyoutOpen] = (0, _react2.useState)(false);
  const [isEditRuleFlyoutOpen, setIsEditRuleFlyoutOpen] = (0, _react2.useState)(false);
  const [isDashboardAttachmentReady, setDashboardAttachmentReady] = (0, _react2.useState)(false);
  const historicalSliData = (0, _chart_data_formatter.formatHistoricalData)(historicalSummary, 'sli_value');
  const {
    handleCreateRule,
    handleAttachToDashboardSave
  } = (0, _use_slo_list_actions.useSloListActions)({
    slo,
    setIsActionsPopoverOpen,
    setIsAddRuleFlyoutOpen
  });
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    className: "sloCardItem",
    panelRef: containerRef,
    paddingSize: "none",
    css: (0, _react.css)`
          height: 182px;
          overflow: hidden;
          position: relative;

          & .sloCardItemActions_hover {
            pointer-events: none;
            opacity: 0;

            &:focus-within {
              pointer-events: auto;
              opacity: 1;
            }
          }
          &:hover .sloCardItemActions_hover {
            pointer-events: auto;
            opacity: 1;
          }
        `,
    title: slo.summary.summaryUpdatedAt ? _i18n.i18n.translate('xpack.slo.sloCardItem.euiPanel.lastSummaryUpdatedLabel', {
      defaultMessage: '{status}, Last summary updated: {value}',
      values: {
        status: slo.summary.status,
        value: (0, _moment.default)(slo.summary.summaryUpdatedAt).fromNow()
      }
    }) : slo.summary.status,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(SloCardChart, {
    slo: slo,
    historicalSliData: historicalSliData,
    badges: /*#__PURE__*/_react2.default.createElement(_slo_card_item_badges.SloCardItemBadges, {
      slo: slo,
      rules: rules,
      activeAlerts: activeAlerts,
      handleCreateRule: handleCreateRule,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 13
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement("div", {
    className: isActionsPopoverOpen ? '' : 'sloCardItemActions_hover',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_slo_card_item_actions.SloCardItemActions, {
    slo: slo,
    rules: rules,
    isActionsPopoverOpen: isActionsPopoverOpen,
    setIsActionsPopoverOpen: setIsActionsPopoverOpen,
    setIsAddRuleFlyoutOpen: setIsAddRuleFlyoutOpen,
    setIsEditRuleFlyoutOpen: setIsEditRuleFlyoutOpen,
    setDashboardAttachmentReady: setDashboardAttachmentReady,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement(_burn_rate_rule_flyout.BurnRateRuleFlyout, {
    slo: slo,
    isAddRuleFlyoutOpen: isAddRuleFlyoutOpen,
    setIsAddRuleFlyoutOpen: setIsAddRuleFlyoutOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_edit_burn_rate_rule_flyout.EditBurnRateRuleFlyout, {
    rule: rules === null || rules === void 0 ? void 0 : rules[0],
    isEditRuleFlyoutOpen: isEditRuleFlyoutOpen,
    setIsEditRuleFlyoutOpen: setIsEditRuleFlyoutOpen,
    refetchRules: refetchRules,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }), isDashboardAttachmentReady ? /*#__PURE__*/_react2.default.createElement(SavedObjectSaveModalDashboard, {
    objectType: _i18n.i18n.translate('xpack.slo.item.actions.addToDashboard.objectTypeLabel', {
      defaultMessage: 'SLO Overview'
    }),
    documentInfo: {
      title: _i18n.i18n.translate('xpack.slo.item.actions.addToDashboard.attachmentTitle', {
        defaultMessage: 'SLO Overview'
      })
    },
    canSaveByReference: false,
    onClose: () => {
      setDashboardAttachmentReady(false);
    },
    onSave: handleAttachToDashboardSave,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }) : null);
}
function SloCardChart({
  slo,
  badges,
  onClick,
  historicalSliData
}) {
  const {
    application: {
      navigateToUrl
    },
    charts
  } = (0, _use_kibana.useKibana)().services;
  const {
    cardColor
  } = useSloCardColor(slo.summary.status);
  const subTitle = getSubTitle(slo);
  const {
    sliValue,
    sloTarget,
    sloDetailsUrl
  } = (0, _use_slo_summary.useSloFormattedSummary)(slo);
  const chartBaseTheme = charts.theme.useChartsBaseTheme();
  return /*#__PURE__*/_react2.default.createElement(_charts.Chart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_charts.Settings, {
    baseTheme: chartBaseTheme,
    theme: {
      metric: {
        iconAlign: 'right'
      }
    },
    onElementClick: ([d]) => {
      if (onClick) {
        onClick();
      } else {
        if ((0, _charts.isMetricElementEvent)(d)) {
          navigateToUrl(sloDetailsUrl);
        }
      }
    },
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_charts.Metric, {
    id: `${slo.id}-${slo.instanceId}`,
    data: [[{
      title: slo.name,
      subtitle: subTitle,
      value: sliValue,
      trendA11yTitle: _i18n.i18n.translate('xpack.slo.slo.sLOGridItem.trendA11yLabel', {
        defaultMessage: `The "{title}" trend`,
        values: {
          title: slo.name
        }
      }),
      trendShape: _charts.MetricTrendShape.Area,
      trend: historicalSliData === null || historicalSliData === void 0 ? void 0 : historicalSliData.map(d => ({
        x: d.key,
        y: d.value
      })),
      extra: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.slo.sLOGridItem.targetFlexItemLabel",
        defaultMessage: "Target {target}",
        values: {
          target: sloTarget
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 17
        }
      }),
      icon: () => /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
        type: "visGauge",
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 247,
          columnNumber: 27
        }
      }),
      color: cardColor,
      body: badges
    }]],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 7
    }
  }));
}