"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingBadges = LoadingBadges;
exports.SloBadges = SloBadges;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _slo_badges = require("../../../../components/slo/slo_badges");
var _slo_active_alerts_badge = require("../../../../components/slo/slo_badges/slo_active_alerts_badge");
var _slo_tags_badge = require("../../../../components/slo/slo_badges/slo_tags_badge");
var _use_url_search_state = require("../../hooks/use_url_search_state");
var _slo_indicator_type_badge = require("./slo_indicator_type_badge");
var _slo_remote_badge = require("./slo_remote_badge");
var _slo_rules_badge = require("./slo_rules_badge");
var _slo_time_window_badge = require("./slo_time_window_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slos/components/badges/slo_badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloBadges({
  activeAlerts,
  isLoading,
  rules,
  slo,
  onClickRuleBadge
}) {
  const {
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const handleTagClick = tag => {
    onStateChange({
      kqlQuery: `slo.tags: "${tag}"`
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    responsive: true,
    gutterSize: "s",
    alignItems: "center",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(LoadingBadges, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_slo_badges.SloStatusBadge, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_badges.SloStateBadge, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_active_alerts_badge.SloActiveAlertsBadge, {
    slo: slo,
    activeAlerts: activeAlerts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_indicator_type_badge.SloIndicatorTypeBadge, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_time_window_badge.SloTimeWindowBadge, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_remote_badge.SloRemoteBadge, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_rules_badge.SloRulesBadge, {
    rules: rules,
    onClick: onClickRuleBadge,
    isRemote: !!slo.remote,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_tags_badge.SloTagsBadge, {
    slo: slo,
    onClick: handleTagClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  })));
}
function LoadingBadges() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: true,
    contentAriaLabel: "Loading",
    width: "54.16px",
    height: "20px",
    borderRadius: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: true,
    contentAriaLabel: "Loading",
    width: "54.16px",
    height: "20px",
    borderRadius: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: true,
    contentAriaLabel: "Loading",
    width: "54.16px",
    height: "20px",
    borderRadius: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }));
}