"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DATA_VIEW_FIELD = void 0;
exports.IndexSelection = IndexSelection;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _public = require("@kbn/unified-search-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _use_adhoc_data_views = require("./use_adhoc_data_views");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/indicator_section/custom_common/index_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BTN_MAX_WIDTH = 515;
const DATA_VIEW_FIELD = exports.DATA_VIEW_FIELD = 'indicator.params.dataViewId';
const INDEX_FIELD = 'indicator.params.index';
const INDICATOR_TIMESTAMP_FIELD = 'indicator.params.timestampField';
const GROUP_BY_FIELD = 'groupBy';
const SETTINGS_SYNC_FIELD = 'settings.syncField';
function IndexSelection({
  selectedDataView
}) {
  const {
    control,
    getFieldState,
    setValue,
    watch
  } = (0, _reactHookForm.useFormContext)();
  const {
    dataViews: dataViewsService,
    dataViewFieldEditor
  } = (0, _use_kibana.useKibana)().services;
  const currentIndexPattern = watch(INDEX_FIELD);
  const currentDataViewId = watch(DATA_VIEW_FIELD);
  const {
    dataViewsList,
    isDataViewsLoading,
    adHocDataViews,
    setAdHocDataViews,
    refetchDataViewsList
  } = (0, _use_adhoc_data_views.useAdhocDataViews)({
    currentIndexPattern
  });
  (0, _react.useEffect)(() => {
    const indPatternId = (0, _use_adhoc_data_views.getDataViewPatternOrId)({
      byPattern: currentIndexPattern,
      dataViewsList,
      adHocDataViews
    });
    if (!currentDataViewId && currentIndexPattern && !isDataViewsLoading && indPatternId) {
      setValue(DATA_VIEW_FIELD, indPatternId);
    }
  }, [adHocDataViews, currentDataViewId, currentIndexPattern, dataViewsList, isDataViewsLoading, setValue]);
  const updateDataViewDependantFields = (indexPattern, timestampField) => {
    setValue(INDEX_FIELD, indexPattern !== null && indexPattern !== void 0 ? indexPattern : '');
    setValue(INDICATOR_TIMESTAMP_FIELD, timestampField !== null && timestampField !== void 0 ? timestampField : '');
    setValue(GROUP_BY_FIELD, _sloSchema.ALL_VALUE);
    setValue(SETTINGS_SYNC_FIELD, null);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: INDEX_LABEL,
    isInvalid: getFieldState(INDEX_FIELD).invalid || getFieldState(DATA_VIEW_FIELD).invalid,
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: "",
    name: DATA_VIEW_FIELD,
    control: control,
    rules: {
      required: true
    },
    render: ({
      field,
      fieldState
    }) => {
      var _field$value;
      return /*#__PURE__*/_react.default.createElement(_public.DataViewPicker, {
        adHocDataViews: adHocDataViews,
        trigger: {
          label: currentIndexPattern || SELECT_DATA_VIEW,
          color: fieldState.invalid ? 'danger' : 'primary',
          isLoading: isDataViewsLoading,
          'data-test-subj': 'indexSelection',
          style: {
            width: '100%',
            maxWidth: BTN_MAX_WIDTH
          }
        },
        onChangeDataView: newId => {
          field.onChange(newId);
          dataViewsService.get(newId).then(dataView => {
            updateDataViewDependantFields((0, _use_adhoc_data_views.getDataViewPatternOrId)({
              byId: newId,
              adHocDataViews,
              dataViewsList
            }), dataView.timeFieldName);
          });
        },
        onAddField: currentDataViewId && selectedDataView ? () => {
          dataViewFieldEditor.openEditor({
            ctx: {
              dataView: selectedDataView
            },
            onSave: () => {}
          });
        } : undefined,
        currentDataViewId: (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : (0, _use_adhoc_data_views.getDataViewPatternOrId)({
          byPattern: currentIndexPattern,
          dataViewsList,
          adHocDataViews
        }),
        onDataViewCreated: dataView => {
          if (!dataView.isPersisted()) {
            setAdHocDataViews(prev => [...prev, dataView]);
          } else {
            refetchDataViewsList();
          }
          field.onChange(dataView.id);
          updateDataViewDependantFields(dataView.getIndexPattern(), dataView.timeFieldName);
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 11
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }));
}
const SELECT_DATA_VIEW = _i18n.i18n.translate('xpack.slo.sloEdit.customKql.dataViewSelection.label', {
  defaultMessage: 'Select a Data view'
});
const INDEX_LABEL = _i18n.i18n.translate('xpack.slo.sloEdit.customKql.indexSelection.label', {
  defaultMessage: 'Index'
});