"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByFieldSelector = GroupByFieldSelector;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _create_options = require("../../helpers/create_options");
var _optional_text = require("./optional_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/common/group_by_field_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const placeholder = _i18n.i18n.translate('xpack.slo.sloEdit.groupBy.placeholder', {
  defaultMessage: 'Select an optional field to group by'
});
function GroupByFieldSelector({
  indexFields,
  isDisabled,
  isLoading
}) {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const [options, setOptions] = (0, _react.useState)((0, _create_options.createOptionsFromFields)(indexFields));
  (0, _react.useEffect)(() => {
    setOptions((0, _create_options.createOptionsFromFields)(indexFields));
  }, [indexFields]);
  const getSelectedItems = value => {
    const values = [value].flat();
    const selectedItems = [];
    indexFields.forEach(field => {
      if (values.includes(field.name)) {
        selectedItems.push({
          value: field.name,
          label: field.name
        });
      }
    });
    return selectedItems;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.slo.sloEdit.groupBy.label', {
      defaultMessage: 'Group by'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.slo.sloEdit.groupBy.tooltip', {
        defaultMessage: 'Create individual SLOs for each value of the selected field.'
      }),
      position: "top",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    })),
    isInvalid: getFieldState('groupBy').invalid,
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 20
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    defaultValue: [_sloSchema.ALL_VALUE],
    name: 'groupBy',
    control: control,
    render: ({
      field,
      fieldState
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
        async: true,
        placeholder: placeholder,
        "aria-label": placeholder,
        isClearable: true,
        isDisabled: isLoading || isDisabled,
        isInvalid: fieldState.invalid,
        isLoading: isLoading,
        onChange: selected => {
          if (selected.length) {
            return field.onChange(selected.map(selection => selection.value));
          }
          field.onChange([_sloSchema.ALL_VALUE]);
        },
        options: options,
        onSearchChange: searchValue => {
          setOptions((0, _create_options.createOptionsFromFields)(indexFields, ({
            value
          }) => value.includes(searchValue)));
        },
        selectedOptions: !!indexFields && !!field.value ? getSelectedItems(field.value) : [],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 13
        }
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }));
}