"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataPreviewChart = DataPreviewChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_preview = require("../../hooks/use_preview");
var _use_section_form_validation = require("../../hooks/use_section_form_validation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/common/data_preview_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DataPreviewChart({
  formatPattern,
  // Specific to timeslice metric indicator type
  threshold,
  thresholdDirection,
  thresholdColor,
  thresholdMessage,
  ignoreMoreThan100
}) {
  var _previewData$results;
  const {
    watch,
    getFieldState,
    formState,
    getValues
  } = (0, _reactHookForm.useFormContext)();
  const {
    charts,
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const {
    isIndicatorSectionValid
  } = (0, _use_section_form_validation.useSectionFormValidation)({
    getFieldState,
    getValues,
    formState,
    watch
  });
  const [range, _] = (0, _react.useState)({
    from: (0, _moment.default)().subtract(1, 'day').toDate(),
    to: new Date()
  });
  const indicator = watch('indicator');
  const groupBy = watch('groupBy');
  const {
    data: previewData,
    isLoading,
    isSuccess,
    isError
  } = (0, _use_preview.useDebouncedGetPreviewData)(isIndicatorSectionValid, indicator, range, groupBy);
  const isMoreThan100 = !ignoreMoreThan100 && (previewData === null || previewData === void 0 ? void 0 : previewData.results.some(datum => datum.sliValue && datum.sliValue > 1));
  const baseTheme = charts.theme.useChartsBaseTheme();
  const dateFormat = uiSettings.get('dateFormat');
  const numberFormat = formatPattern != null ? formatPattern : uiSettings.get('format:percent:defaultPattern');
  const {
    maxValue,
    minValue,
    domain
  } = getChartDomain(previewData, threshold);
  const title = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloEdit.dataPreviewChart.panelLabel",
    defaultMessage: "SLI preview",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }));
  if (!isIndicatorSectionValid) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    }, title, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      hasShadow: false,
      style: {
        minHeight: 194
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      style: {
        minHeight: 160
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.slo.sloEdit.dataPreviewChart.explanationMessage', {
      defaultMessage: 'Fill the indicator fields to see visualisation of the current metrics'
    }))))));
  }
  const annotation = threshold != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "thresholdAnnotation",
    domainType: _charts.AnnotationDomainType.YDomain,
    dataValues: [{
      dataValue: threshold
    }],
    style: {
      line: {
        strokeWidth: 2,
        stroke: thresholdColor !== null && thresholdColor !== void 0 ? thresholdColor : '#000',
        opacity: 1
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.RectAnnotation, {
    dataValues: [{
      coordinates: thresholdDirection === 'above' ? {
        y0: threshold,
        y1: maxValue
      } : {
        y0: minValue,
        y1: threshold
      },
      details: thresholdMessage
    }],
    id: "thresholdShade",
    style: {
      fill: thresholdColor !== null && thresholdColor !== void 0 ? thresholdColor : '#000',
      opacity: 0.1
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }));
  const columns = [{
    id: 'color',
    type: 'color'
  }, {
    id: 'group',
    type: 'custom',
    header: _i18n.i18n.translate('xpack.slo.sloEdit.dataPreviewChart.tooltip.groupLabel', {
      defaultMessage: 'Group'
    }),
    truncate: true,
    cell: ({
      label: cellLabel
    }) => /*#__PURE__*/_react.default.createElement("span", {
      className: "echTooltip__label",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 39
      }
    }, cellLabel),
    style: {
      textAlign: 'left'
    }
  }, {
    id: 'sli',
    type: 'custom',
    header: _i18n.i18n.translate('xpack.slo.sloEdit.dataPreviewChart.tooltip.sliLabel', {
      defaultMessage: 'SLI'
    }),
    cell: ({
      formattedValue
    }) => /*#__PURE__*/_react.default.createElement("span", {
      className: "echTooltip__value",
      dir: "ltr",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 9
      }
    }, formattedValue),
    style: {
      textAlign: 'right'
    }
  }, {
    id: 'good',
    type: 'custom',
    header: _i18n.i18n.translate('xpack.slo.sloEdit.dataPreviewChart.tooltip.goodEventsLabel', {
      defaultMessage: 'Good events'
    }),
    cell: ({
      datum
    }) => {
      var _datum$events$good, _datum$events;
      return /*#__PURE__*/_react.default.createElement("span", {
        className: "echTooltip__value",
        dir: "ltr",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 9
        }
      }, (_datum$events$good = (_datum$events = datum.events) === null || _datum$events === void 0 ? void 0 : _datum$events.good) !== null && _datum$events$good !== void 0 ? _datum$events$good : '-');
    },
    style: {
      textAlign: 'right'
    }
  }, {
    id: 'total',
    type: 'custom',
    header: _i18n.i18n.translate('xpack.slo.sloEdit.dataPreviewChart.tooltip.totalEventsLabel', {
      defaultMessage: 'Total events'
    }),
    cell: ({
      datum
    }) => {
      var _datum$events$total, _datum$events2;
      return /*#__PURE__*/_react.default.createElement("span", {
        className: "echTooltip__value",
        dir: "ltr",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 9
        }
      }, (_datum$events$total = (_datum$events2 = datum.events) === null || _datum$events2 === void 0 ? void 0 : _datum$events2.total) !== null && _datum$events$total !== void 0 ? _datum$events$total : '-');
    },
    style: {
      textAlign: 'right'
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 5
    }
  }, title, isMoreThan100 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    title: _i18n.i18n.translate('xpack.slo.sloEdit.dataPreviewChart.moreThan100', {
      defaultMessage: 'Some of the SLI values are more than 100%. That means good query is returning more results than total query.'
    }),
    iconType: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    style: {
      minHeight: 194
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 9
    }
  }, (isLoading || isError) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    style: {
      height: 160
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 15
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 31
    }
  }), isError && /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.slo.sloEdit.dataPreviewChart.errorMessage', {
    defaultMessage: 'The current indicator settings are invalid'
  })))), isSuccess && /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 160,
      width: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: "vertical",
    body: ({
      items
    }) => {
      return /*#__PURE__*/_react.default.createElement(_charts.TooltipTable, {
        columns: columns,
        items: items,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 260,
          columnNumber: 26
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    showLegend: true,
    legendPosition: _charts.Position.Right,
    theme: [{
      lineSeriesStyle: {
        point: {
          visible: 'never'
        }
      }
    }],
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 15
    }
  }), annotation, /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "value",
    title: _i18n.i18n.translate('xpack.slo.sloEdit.dataPreviewChart.yTitle', {
      defaultMessage: 'SLI'
    }),
    ticks: 5,
    position: _charts.Position.Left,
    tickFormat: d => (0, _numeral.default)(d).format(numberFormat),
    domain: domain,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "time",
    title: _i18n.i18n.translate('xpack.slo.sloEdit.dataPreviewChart.xTitle', {
      defaultMessage: 'Last 24 hours'
    }),
    tickFormat: d => (0, _moment.default)(d).format(dateFormat),
    position: _charts.Position.Bottom,
    gridLine: {
      visible: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: "All groups"
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "date",
    yAccessors: ['value'],
    data: ((_previewData$results = previewData === null || previewData === void 0 ? void 0 : previewData.results) !== null && _previewData$results !== void 0 ? _previewData$results : []).map(datum => ({
      date: new Date(datum.date).getTime(),
      value: datum.sliValue && datum.sliValue >= 0 ? datum.sliValue : null,
      events: datum.events
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 15
    }
  }), (0, _lodash.map)(previewData === null || previewData === void 0 ? void 0 : previewData.groups, (data, group) => /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    key: group,
    id: group
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "date",
    yAccessors: ['value'],
    data: data.map(datum => ({
      date: new Date(datum.date).getTime(),
      value: datum.sliValue && datum.sliValue >= 0 ? datum.sliValue : null,
      events: datum.events
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 17
    }
  }))))));
}
function getChartDomain(previewData, threshold) {
  var _min, _max;
  const allGroupsValues = (0, _lodash.map)(previewData === null || previewData === void 0 ? void 0 : previewData.results, datum => datum.sliValue);
  const groupsValues = (0, _lodash.values)(previewData === null || previewData === void 0 ? void 0 : previewData.groups).flat().map(datum => datum.sliValue);
  const maxValue = (0, _lodash.max)(allGroupsValues.concat(groupsValues));
  const minValue = (0, _lodash.min)(allGroupsValues.concat(groupsValues));
  const domain = {
    fit: true,
    min: (_min = (0, _lodash.min)([threshold, minValue])) !== null && _min !== void 0 ? _min : NaN,
    max: (_max = (0, _lodash.max)([threshold, maxValue])) !== null && _max !== void 0 ? _max : NaN
  };
  return {
    maxValue,
    minValue,
    domain
  };
}