"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OVERVIEW_TAB_ID = exports.HISTORY_TAB_ID = exports.DEFINITION_TAB_ID = exports.ALERTS_TAB_ID = void 0;
exports.SloDetails = SloDetails;
exports.TAB_ID_URL_PARAM = void 0;
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _burn_rate_panel = require("./burn_rate_panel/burn_rate_panel");
var _events_chart_panel = require("./events_chart_panel/events_chart_panel");
var _historical_data_charts = require("./historical_data_charts");
var _slo_details_history = require("./history/slo_details_history");
var _definition = require("./definition/definition");
var _slo_detail_alerts = require("./slo_detail_alerts");
var _slo_health_callout = require("./slo_health_callout");
var _slo_remote_callout = require("./slo_remote_callout");
var _action_modal = require("../../../context/action_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_details/components/slo_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TAB_ID_URL_PARAM = exports.TAB_ID_URL_PARAM = 'tabId';
const OVERVIEW_TAB_ID = exports.OVERVIEW_TAB_ID = 'overview';
const HISTORY_TAB_ID = exports.HISTORY_TAB_ID = 'history';
const DEFINITION_TAB_ID = exports.DEFINITION_TAB_ID = 'definition';
const ALERTS_TAB_ID = exports.ALERTS_TAB_ID = 'alerts';
function SloDetails({
  slo,
  isAutoRefreshing,
  selectedTabId
}) {
  const [range, setRange] = (0, _react.useState)(() => {
    const now = new Date();
    return {
      from: (0, _moment.default)(now).subtract(1, 'day').toDate(),
      to: now
    };
  });
  (0, _react.useEffect)(() => {
    let intervalId;
    if (isAutoRefreshing) {
      intervalId = setInterval(() => {
        const now = new Date();
        setRange({
          from: (0, _moment.default)(now).subtract(1, 'day').toDate(),
          to: now
        });
      }, 60 * 1000);
    }
    return () => clearInterval(intervalId);
  }, [isAutoRefreshing]);
  if (selectedTabId === HISTORY_TAB_ID) {
    return /*#__PURE__*/_react.default.createElement(_slo_details_history.SloDetailsHistory, {
      slo: slo,
      isAutoRefreshing: isAutoRefreshing,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 12
      }
    });
  }
  if (selectedTabId === DEFINITION_TAB_ID) {
    return /*#__PURE__*/_react.default.createElement(_definition.Definition, {
      slo: slo,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 12
      }
    });
  }
  if (selectedTabId === ALERTS_TAB_ID) {
    return /*#__PURE__*/_react.default.createElement(_slo_detail_alerts.SloDetailsAlerts, {
      slo: slo,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_action_modal.ActionModalProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_slo_remote_callout.SloRemoteCallout, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_slo_health_callout.SloHealthCallout, {
    slo: slo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_burn_rate_panel.BurnRatePanel, {
    slo: slo,
    isAutoRefreshing: isAutoRefreshing,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_historical_data_charts.HistoricalDataCharts, {
    slo: slo,
    isAutoRefreshing: isAutoRefreshing,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_events_chart_panel.EventsChartPanel, {
    slo: slo,
    range: range,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }))));
}