"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloConfiguration = SloConfiguration;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sloSchema = require("@kbn/slo-schema");
var _react2 = _interopRequireWildcard(require("react"));
var _slo_selector = require("./slo_selector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/alerts/slo_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloConfiguration({
  initialInput,
  onCreate,
  onCancel
}) {
  var _initialInput$showAll, _initialInput$slos;
  const [showAllGroupByInstances, setShowAllGroupByInstances] = (0, _react2.useState)((_initialInput$showAll = initialInput === null || initialInput === void 0 ? void 0 : initialInput.showAllGroupByInstances) !== null && _initialInput$showAll !== void 0 ? _initialInput$showAll : false);
  const [selectedSlos, setSelectedSlos] = (0, _react2.useState)((_initialInput$slos = initialInput === null || initialInput === void 0 ? void 0 : initialInput.slos) !== null && _initialInput$slos !== void 0 ? _initialInput$slos : []);
  const [hasError, setHasError] = (0, _react2.useState)(false);
  const onConfirmClick = () => onCreate({
    slos: selectedSlos,
    showAllGroupByInstances
  });
  const hasGroupBy = selectedSlos === null || selectedSlos === void 0 ? void 0 : selectedSlos.some(slo => slo.instanceId !== _sloSchema.ALL_VALUE);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'alertsConfigurationFlyout'
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyout, {
    onClose: onCancel,
    css: (0, _react.css)`
        min-width: 550px;
      `,
    "aria-labelledby": flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyoutHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement("h2", {
    id: flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.slo.sloEmbeddable.config.sloSelector.headerTitle', {
    defaultMessage: 'Alerts configuration'
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_slo_selector.SloSelector, {
    initialSlos: selectedSlos,
    hasError: hasError,
    singleSelection: false,
    onSelected: slos => {
      setHasError(slos === undefined);
      if (Array.isArray(slos)) {
        setSelectedSlos(slos === null || slos === void 0 ? void 0 : slos.map(slo => ({
          id: slo === null || slo === void 0 ? void 0 : slo.id,
          instanceId: slo === null || slo === void 0 ? void 0 : slo.instanceId,
          name: slo === null || slo === void 0 ? void 0 : slo.name,
          groupBy: slo === null || slo === void 0 ? void 0 : slo.groupBy
        })));
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }))), hasGroupBy && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.slo.sloConfiguration.euiSwitch.showAllGroupByLabel', {
      defaultMessage: 'Show all related group-by instances'
    }),
    checked: showAllGroupByInstances,
    onChange: e => {
      setShowAllGroupByInstances(e.target.checked);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "sloCancelButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.Embeddable.config.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sloConfirmButton",
    isDisabled: !selectedSlos || selectedSlos.length === 0 || hasError,
    onClick: onConfirmClick,
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.embeddableSlo.config.confirmButtonLabel",
    defaultMessage: "Confirm configurations",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  })))));
}