"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloActiveAlertsBadge = SloActiveAlertsBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _use_kibana = require("../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/slo/slo_badges/slo_active_alerts_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloActiveAlertsBadge({
  slo,
  activeAlerts,
  viewMode = 'default'
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _use_kibana.useKibana)().services;
  const handleActiveAlertsClick = () => {
    if (activeAlerts) {
      const kuery = encodeURIComponent(`'slo.id:"${slo.id}" and slo.instanceId:"${slo.instanceId}"'`);
      navigateToUrl(`${basePath.prepend(_common.observabilityPaths.alerts)}?_a=(kuery:${kuery},rangeFrom:now-15m,rangeTo:now,status:active)`);
    }
  };
  if (!activeAlerts) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.slo.slo.activeAlertsBadge.tooltip', {
      defaultMessage: '{count, plural, one {# burn rate alert} other {# burn rate alerts}}, click to view.',
      values: {
        count: activeAlerts
      }
    }),
    display: "block",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "warning",
    color: "danger",
    onClick: handleActiveAlertsClick,
    onClickAriaLabel: _i18n.i18n.translate('xpack.slo.slo.activeAlertsBadge.ariaLabel', {
      defaultMessage: 'active alerts badge'
    }),
    "data-test-subj": "o11ySloActiveAlertsBadge",
    onMouseDown: e => {
      e.stopPropagation(); // stops propagation of metric onElementClick
    },
    css: {
      cursor: 'pointer'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, viewMode !== 'default' ? activeAlerts : _i18n.i18n.translate('xpack.slo.slo.activeAlertsBadge.label', {
    defaultMessage: '{count, plural, one {# alert} other {# alerts}}',
    values: {
      count: activeAlerts
    }
  }))));
}