"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyEditor = DependencyEditor;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _Either = require("fp-ts/Either");
var _types = require("../../../common/types");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/slo/public/components/burn_rate_rule_editor/dependency_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ACTION_GROUP_OPTIONS = [{
  value: _constants.ALERT_ACTION.id,
  label: _constants.ALERT_ACTION.name
}, {
  value: _constants.HIGH_PRIORITY_ACTION.id,
  label: _constants.HIGH_PRIORITY_ACTION.name
}, {
  value: _constants.MEDIUM_PRIORITY_ACTION.id,
  label: _constants.MEDIUM_PRIORITY_ACTION.name
}, {
  value: _constants.LOW_PRIORITY_ACTION.id,
  label: _constants.LOW_PRIORITY_ACTION.name
}];
function DependencyEditor({
  isLoading,
  onSubmit,
  dependency,
  rules
}) {
  var _rules$map;
  const isEditMode = dependency != null;
  const [isOpen, setPopoverState] = (0, _react.useState)(false);
  const [partialDependency, setPartialDependency] = (0, _react.useState)(dependency || {});
  const handleOpenPopover = () => setPopoverState(true);
  const handleClosePopover = () => {
    if (!isEditMode) {
      setPartialDependency({});
    }
    setPopoverState(false);
  };
  const handleRuleSelection = opts => {
    if (opts.length > 0 && opts[0].value) {
      setPartialDependency(previous => ({
        ...previous,
        ruleId: opts[0].value
      }));
    }
  };
  const handleActionGroupSelection = opts => {
    if (opts.length > 0 && opts.every(opt => !!opt.value)) {
      const values = opts.map(opt => opt.value);
      setPartialDependency(previous => ({
        ...previous,
        actionGroupsToSuppressOn: values
      }));
    }
  };
  const rulesOptions = (_rules$map = rules === null || rules === void 0 ? void 0 : rules.map(rule => ({
    label: rule.name,
    value: rule.id
  }))) !== null && _rules$map !== void 0 ? _rules$map : [];
  const selectedRuleOption = rulesOptions === null || rulesOptions === void 0 ? void 0 : rulesOptions.filter(opt => opt.value === partialDependency.ruleId);
  const selectedRule = rules === null || rules === void 0 ? void 0 : rules.find(rule => rule.id === partialDependency.ruleId);
  const ruleActionGroups = selectedRule && selectedRule.params.windows.map(winDef => winDef.actionGroup) || [];
  const actionGroupOptions = ACTION_GROUP_OPTIONS.filter(group => ruleActionGroups.includes(group.value));
  const selectedActionGroups = ACTION_GROUP_OPTIONS.filter(group => {
    var _partialDependency$ac;
    return (_partialDependency$ac = partialDependency.actionGroupsToSuppressOn) === null || _partialDependency$ac === void 0 ? void 0 : _partialDependency$ac.includes(group.value);
  });
  const handleSubmit = () => {
    const dep = _types.DependencyRT.decode(partialDependency);
    if ((0, _Either.isRight)(dep)) {
      onSubmit(dep.right);
    }
    handleClosePopover();
  };
  const button = isEditMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    isDisabled: isLoading,
    "data-test-subj": "sloBurnRateRuleEditDependencyButton",
    color: 'primary',
    size: "s",
    iconType: 'pencil',
    onClick: handleOpenPopover,
    "aria-label": _i18n.i18n.translate('xpack.slo.rules.editDependencyAriaLabel', {
      defaultMessage: 'Edit dependency'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isDisabled: isLoading || (rules === null || rules === void 0 ? void 0 : rules.length) === 0,
    "data-test-subj": "sloBurnRateRuleAddDependencyButton",
    color: 'primary',
    size: "s",
    iconType: 'plusInCircleFilled',
    onClick: handleOpenPopover,
    "aria-label": _i18n.i18n.translate('xpack.slo.rules.addDependencyAriaLabel', {
      defaultMessage: 'Add dependency'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.rules.addDependencyLabel",
    defaultMessage: "Add dependency",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isOpen,
    closePopover: handleSubmit,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 400
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.slo.rules.addDependencyForm.ruleLabel', {
      defaultMessage: 'Rule (required)'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    compressed: true,
    fullWidth: true,
    options: rulesOptions,
    singleSelection: {
      asPlainText: true
    },
    isLoading: isLoading,
    onChange: handleRuleSelection,
    selectedOptions: selectedRuleOption,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.slo.rules.addDependencyForm.suppressOnLabel', {
      defaultMessage: 'Suppress on (required)'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    compressed: true,
    fullWidth: true,
    isDisabled: !partialDependency.ruleId,
    options: actionGroupOptions,
    onChange: handleActionGroupSelection,
    selectedOptions: selectedActionGroups,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  })))));
}