"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaSectionErrorBoundary = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _apmRum = require("@elastic/apm-rum");
var _lib = require("../../lib");
var _services = require("../services");
var _message_components = require("./message_components");
var _base_error_boundary = require("./base_error_boundary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/shared-ux/error_boundary/src/ui/section_error_boundary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * `KibanaSectionErrorBoundary` is designed to capture errors at a granular level.
 *
 * In general, it's best to use `KibanaErrorBoundary` and block the whole page.
 * Users will see an error state on the page and think that there are instabilities in the system.
 * They will be / should be wary about making any changes in a UI showing an error, since it risks
 * further instability.
 *
 * If it is acceptable to assume the risk of allowing users to interact with a UI that
 * has an error state, then using `KibanaSectionErrorBoundary` may be an acceptable alternative,
 * but this must be judged on a case-by-case basis.
 *
 * @example
 * ```tsx
 * <KibanaSectionErrorBoundary sectionName="Dashboard" maxRetries={3}>
 *   <MySection />
 * </KibanaSectionErrorBoundary>
 * ```
 */
const KibanaSectionErrorBoundary = props => {
  const services = (0, _services.useErrorBoundary)();
  return /*#__PURE__*/_react.default.createElement(SectionErrorBoundaryInternal, (0, _extends2.default)({}, props, {
    services: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 10
    }
  }));
};
exports.KibanaSectionErrorBoundary = KibanaSectionErrorBoundary;
class SectionErrorBoundaryInternal extends _base_error_boundary.BaseErrorBoundary {
  constructor(props) {
    super(props);
    this.state = {
      error: null,
      errorInfo: null,
      componentName: null,
      isFatal: null,
      retryCount: 0
    };
  }
  componentDidCatch(error, errorInfo) {
    _apmRum.apm.captureError(error, {
      labels: (0, _lib.getErrorBoundaryLabels)('SectionFatalReactError')
    });
    console.error('Error caught by Kibana React Error Boundary'); // eslint-disable-line no-console
    console.error(error); // eslint-disable-line no-console

    // Enqueue the error instead of registering it immediately
    const enqueuedError = this.props.services.errorService.enqueueError(error, errorInfo);
    const {
      id: errorId,
      isFatal,
      name
    } = enqueuedError;
    this.setState(prevState => {
      var _prevState$retryCount;
      const nextRetryCount = ((_prevState$retryCount = prevState.retryCount) !== null && _prevState$retryCount !== void 0 ? _prevState$retryCount : 0) + 1;
      return {
        error,
        errorInfo,
        componentName: name,
        isFatal,
        errorId,
        retryCount: nextRetryCount
      };
    });
  }
  render() {
    const {
      error,
      retryCount = 0
    } = this.state;
    const {
      maxRetries = 0
    } = this.props;
    const hasRetriesRemaining = retryCount <= maxRetries && error !== null;

    // If there are retries remaining, remount children with fresh state
    if (hasRetriesRemaining) {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: retryCount,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 14
        }
      }, this.props.children);
    }

    // Once retries are exhausted or no error, show normal children or error prompt
    if (!error) {
      return this.props.children;
    }
    const {
      errorInfo,
      componentName,
      isFatal
    } = this.state;
    if (isFatal) {
      return /*#__PURE__*/_react.default.createElement(_message_components.SectionFatalPrompt, {
        sectionName: this.props.sectionName,
        error: error,
        errorInfo: errorInfo,
        name: componentName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_message_components.SectionRecoverablePrompt, {
      sectionName: this.props.sectionName,
      onClickRefresh: this.props.services.onClickRefresh,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 7
      }
    });
  }
}