"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TTYPlayer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _useResizeObserver = _interopRequireDefault(require("use-resize-observer"));
var _lodash = require("lodash");
var _tty_search_bar = require("../tty_search_bar");
var _tty_text_sizer = require("../tty_text_sizer");
var _styles = require("./styles");
var _constants = require("../../../common/constants");
var _hooks = require("./hooks");
var _tty_player_controls = require("../tty_player_controls");
var _translations = require("../session_view/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/session_view/public/components/tty_player/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TTYPlayer = ({
  index,
  sessionEntityId,
  sessionStartTime,
  show,
  onClose,
  onJumpToEvent,
  autoSeekToEntityId,
  canReadPolicyManagement,
  trackEvent
}) => {
  var _lines$Math$min, _currentProcessEvent$, _currentProcessEvent$3;
  const ref = (0, _react.useRef)(null);
  const {
    ref: scrollRef,
    height: containerHeight = 1
  } = (0, _useResizeObserver.default)({});
  const {
    data,
    fetchNextPage,
    hasNextPage,
    isFetching,
    refetch
  } = (0, _hooks.useFetchIOEvents)(index, sessionEntityId, sessionStartTime);
  const {
    lines,
    processStartMarkers
  } = (0, _hooks.useIOLines)(data === null || data === void 0 ? void 0 : data.pages);
  const [fontSize, setFontSize] = (0, _react.useState)(_constants.DEFAULT_TTY_FONT_SIZE);
  const [isPlaying, setIsPlaying] = (0, _react.useState)(false);
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const [currentAutoSeekEntityId, setCurrentAutoSeekEntityId] = (0, _react.useState)('');
  const {
    getUrlForApp
  } = (0, _public.useKibana)().services.application;
  const policiesUrl = (0, _react.useMemo)(() => canReadPolicyManagement ? getUrlForApp(_constants.SECURITY_APP_ID, {
    path: _constants.POLICIES_PAGE_PATH
  }) : '', [canReadPolicyManagement, getUrlForApp]);
  const {
    search,
    currentLine,
    seekToLine
  } = (0, _hooks.useXtermPlayer)({
    ref,
    isPlaying,
    setIsPlaying,
    lines,
    fontSize,
    hasNextPage,
    fetchNextPage,
    isFetching,
    policiesUrl
  });
  const currentProcessEvent = (_lines$Math$min = lines[Math.min(lines.length - 1, currentLine)]) === null || _lines$Math$min === void 0 ? void 0 : _lines$Math$min.event;
  const tty = currentProcessEvent === null || currentProcessEvent === void 0 ? void 0 : (_currentProcessEvent$ = currentProcessEvent.process) === null || _currentProcessEvent$ === void 0 ? void 0 : _currentProcessEvent$.tty;
  (0, _react.useEffect)(() => {
    if (show) {
      // refetch the most recent page when tty player is loaded
      refetch({
        refetchPage: (_page, i, allPages) => allPages.length - 1 === i
      });
    }
  }, [refetch, show]);
  (0, _react.useEffect)(() => {
    var _currentProcessEvent$2;
    if (autoSeekToEntityId && currentAutoSeekEntityId !== autoSeekToEntityId && (currentProcessEvent === null || currentProcessEvent === void 0 ? void 0 : (_currentProcessEvent$2 = currentProcessEvent.process) === null || _currentProcessEvent$2 === void 0 ? void 0 : _currentProcessEvent$2.entity_id) !== autoSeekToEntityId) {
      const foundMarker = processStartMarkers.find(marker => {
        var _marker$event$process;
        if (((_marker$event$process = marker.event.process) === null || _marker$event$process === void 0 ? void 0 : _marker$event$process.entity_id) === autoSeekToEntityId) {
          return true;
        }
        return false;
      });
      if (foundMarker) {
        seekToLine(foundMarker.line);
        setCurrentAutoSeekEntityId(autoSeekToEntityId);
      } else {
        seekToLine(lines.length - 1); // seek to end to force next page to load.
      }
    }
  }, [autoSeekToEntityId, currentAutoSeekEntityId, currentProcessEvent === null || currentProcessEvent === void 0 ? void 0 : (_currentProcessEvent$3 = currentProcessEvent.process) === null || _currentProcessEvent$3 === void 0 ? void 0 : _currentProcessEvent$3.entity_id, lines.length, processStartMarkers, seekToLine]);
  const validTTY = (tty === null || tty === void 0 ? void 0 : tty.rows) && (tty === null || tty === void 0 ? void 0 : tty.rows) > 1 && (tty === null || tty === void 0 ? void 0 : tty.rows) < 1000;
  if (tty && !validTTY) {
    tty.rows = _constants.DEFAULT_TTY_ROWS;
    tty.columns = _constants.DEFAULT_TTY_COLS;
  }
  const styles = (0, _styles.useStyles)(tty, show);
  const clearSearch = (0, _react.useCallback)(() => {
    if (searchQuery) {
      setSearchQuery('');
    }
  }, [searchQuery]);
  const onSeekLine = (0, _react.useMemo)(() => {
    return (0, _lodash.throttle)(line => {
      clearSearch();
      seekToLine(line);
    }, 100);
  }, [clearSearch, seekToLine]);
  const onTogglePlayback = (0, _react.useCallback)(() => {
    // if at the end, seek to beginning
    if (currentLine >= lines.length - 1) {
      seekToLine(0);
    }
    setIsPlaying(!isPlaying);
    if (isPlaying) {
      trackEvent('tty_playback_started');
    } else {
      trackEvent('tty_playback_stopped');
    }
  }, [currentLine, isPlaying, lines.length, seekToLine, trackEvent]);
  (0, _react.useEffect)(() => {
    if (isPlaying) {
      clearSearch();
    }
  }, [clearSearch, isPlaying]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    borderRadius: "none",
    hasBorder: false,
    css: styles.header,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "sessionView:TTYSearch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_tty_search_bar.TTYSearchBar, {
    lines: lines,
    seekToLine: seekToLine,
    xTermSearchFn: search,
    setIsPlaying: setIsPlaying,
    searchQuery: searchQuery,
    setSearchQuery: setSearchQuery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    isSelected: true,
    display: "fill",
    isLoading: isFetching,
    iconType: "apmTrace",
    onClick: onClose,
    size: "m",
    "aria-label": _translations.TOGGLE_TTY_PLAYER,
    "data-test-subj": "sessionView:TTYPlayerClose",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "refresh",
    display: "empty",
    size: "m",
    disabled: true,
    "aria-label": "disabled",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "eye",
    disabled: true,
    size: "m",
    "aria-label": "disabled",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "list",
    disabled: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 13
    }
  }, _translations.DETAIL_PANEL)))), /*#__PURE__*/_react.default.createElement("div", {
    ref: scrollRef,
    className: "eui-scrollBar",
    css: styles.scrollPane,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: ref,
    "data-test-subj": "sessionView:TTYPlayer",
    css: styles.terminal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_tty_player_controls.TTYPlayerControls, {
    currentProcessEvent: currentProcessEvent,
    processStartMarkers: processStartMarkers,
    isPlaying: isPlaying,
    currentLine: currentLine,
    linesLength: lines.length,
    onSeekLine: onSeekLine,
    onTogglePlayback: onTogglePlayback,
    onClose: onClose,
    onJumpToEvent: onJumpToEvent,
    textSizer: /*#__PURE__*/_react.default.createElement(_tty_text_sizer.TTYTextSizer, {
      tty: tty,
      containerHeight: containerHeight,
      fontSize: fontSize,
      onFontSizeChanged: setFontSize,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  })));
};
exports.TTYPlayer = TTYPlayer;