"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessPlugin = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _navigation = require("./navigation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/serverless/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class ServerlessPlugin {
  constructor() {}
  setup(_core, _dependencies) {
    return {};
  }
  start(core, dependencies) {
    const {
      chrome,
      rendering
    } = core;

    // Casting the "chrome.project" service to an "internal" type: this is intentional to obscure the property from Typescript.
    const {
      project
    } = chrome;
    const {
      cloud
    } = dependencies;
    chrome.setChromeStyle('project');
    if (cloud.serverless.projectName) {
      project.setProjectName(cloud.serverless.projectName);
    }
    project.setCloudUrls(cloud.getUrls()); // Ensure the project has the non-privileged URLs immediately
    cloud.getPrivilegedUrls().then(privilegedUrls => {
      if (Object.keys(privilegedUrls).length === 0) return;
      project.setCloudUrls({
        ...privilegedUrls,
        ...cloud.getUrls()
      }); // Merge the privileged URLs once available
    });
    chrome.navControls.registerRight({
      order: 1,
      mount: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        href: "https://ela.st/serverless-feedback",
        size: 's',
        color: 'warning',
        iconType: 'popout',
        iconSide: 'right',
        target: '_blank',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 9
        }
      }, _i18n.i18n.translate('xpack.serverless.header.giveFeedbackBtn.label', {
        defaultMessage: 'Give feedback'
      })), rendering)
    });
    return {
      initNavigation: (id, navigationTree$, config) => {
        project.initNavigation(id, navigationTree$, config);
      },
      setBreadcrumbs: (breadcrumbs, params) => project.setBreadcrumbs(breadcrumbs, params),
      setProjectHome: homeHref => project.setHome(homeHref),
      getNavigationCards: (roleManagementEnabled, extendCardNavDefinitions) => {
        if (!roleManagementEnabled) return extendCardNavDefinitions;
        const manageOrgMembersNavCard = (0, _navigation.generateManageOrgMembersNavCard)(cloud.usersAndRolesUrl);
        if (extendCardNavDefinitions) {
          extendCardNavDefinitions[_navigation.manageOrgMembersNavCardName] = manageOrgMembersNavCard;
          return extendCardNavDefinitions;
        }
        return {
          [_navigation.manageOrgMembersNavCardName]: manageOrgMembersNavCard
        };
      }
    };
  }
  stop() {}
}
exports.ServerlessPlugin = ServerlessPlugin;