"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPGRADE_PRODUCT_MESSAGE = exports.TIER_REQUIRED = exports.CONTACT_ADMINISTRATOR = exports.AutomaticImport = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_product_type_by_pli = require("../../hooks/use_product_type_by_pli");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution_serverless/public/upselling/sections/automatic_import/automatic_import.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UPGRADE_PRODUCT_MESSAGE = requiredProductType => _i18n.i18n.translate('xpack.securitySolutionServerless.upselling.automaticImport.upgradeProductMessage', {
  defaultMessage: 'To turn on the Automatic Import feature, you must upgrade the product tier to {requiredProductType}',
  values: {
    requiredProductType
  }
});
exports.UPGRADE_PRODUCT_MESSAGE = UPGRADE_PRODUCT_MESSAGE;
const TIER_REQUIRED = requiredProductType => _i18n.i18n.translate('xpack.securitySolutionServerless.upselling.automaticImport.tierRequired', {
  defaultMessage: '{requiredProductType} tier required',
  values: {
    requiredProductType
  }
});
exports.TIER_REQUIRED = TIER_REQUIRED;
const CONTACT_ADMINISTRATOR = exports.CONTACT_ADMINISTRATOR = _i18n.i18n.translate('xpack.securitySolutionServerless.upselling.automaticImport.contactAdministrator', {
  defaultMessage: 'Contact your administrator for assistance.'
});
const AutomaticImport = exports.AutomaticImport = /*#__PURE__*/_react.default.memo(({
  requiredPLI
}) => {
  const requiredProductType = (0, _use_product_type_by_pli.useProductTypeByPLI)(requiredPLI);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": 'EnterpriseLicenseRequiredCard',
    betaBadgeProps: {
      label: requiredProductType
    },
    isDisabled: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "lock",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 15
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 13
      }
    }, TIER_REQUIRED(requiredProductType))),
    description: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "lockedCardDescription",
    direction: "column",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 17
    }
  }, UPGRADE_PRODUCT_MESSAGE(requiredProductType))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, CONTACT_ADMINISTRATOR)))));
});
AutomaticImport.displayName = 'IntegrationsAssistant';