"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiemMigrationsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _siem_rule_migrations_service = require("./rules/siem_rule_migrations_service");
var _siem_dashboard_migration_service = require("./dashboards/siem_dashboard_migration_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SiemMigrationsService {
  constructor(config, logger, kibanaVersion) {
    var _config$siemRuleMigra, _config$siemRuleMigra2;
    (0, _defineProperty2.default)(this, "pluginStop$", void 0);
    (0, _defineProperty2.default)(this, "rulesService", void 0);
    (0, _defineProperty2.default)(this, "dashboardsService", void 0);
    this.config = config;
    this.pluginStop$ = new _rxjs.ReplaySubject(1);
    this.rulesService = new _siem_rule_migrations_service.SiemRuleMigrationsService(logger, kibanaVersion, (_config$siemRuleMigra = config.siemRuleMigrations) === null || _config$siemRuleMigra === void 0 ? void 0 : _config$siemRuleMigra.elserInferenceId);
    this.dashboardsService = new _siem_dashboard_migration_service.SiemDashboardMigrationsService(logger, kibanaVersion, (_config$siemRuleMigra2 = config.siemRuleMigrations) === null || _config$siemRuleMigra2 === void 0 ? void 0 : _config$siemRuleMigra2.elserInferenceId);
  }
  setup(params) {
    if (!this.config.experimentalFeatures.siemMigrationsDisabled) {
      this.rulesService.setup({
        ...params,
        pluginStop$: this.pluginStop$
      });
      if (this.config.experimentalFeatures.automaticDashboardsMigration) {
        this.dashboardsService.setup({
          ...params,
          pluginStop$: this.pluginStop$
        });
      }
    }
  }
  createRulesClient(params) {
    return this.rulesService.createClient(params);
  }
  createDashboardsClient(params) {
    return this.dashboardsService.createClient(params);
  }
  stop() {
    this.rulesService.stop();
    this.dashboardsService.stop();
    this.pluginStop$.next();
    this.pluginStop$.complete();
  }
}
exports.SiemMigrationsService = SiemMigrationsService;