"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTranslateRuleNode = void 0;
var _translate_spl_to_esql = require("../../../../../../../common/task/agent/helpers/translate_spl_to_esql");
var _severity = require("./severity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTranslateRuleNode = params => {
  const translateSplToEsql = (0, _translate_spl_to_esql.getTranslateSplToEsql)(params);
  return async state => {
    var _state$integration, _state$integration$da, _state$integration2;
    const indexPatterns = ((_state$integration = state.integration) === null || _state$integration === void 0 ? void 0 : (_state$integration$da = _state$integration.data_streams) === null || _state$integration$da === void 0 ? void 0 : _state$integration$da.map(dataStream => dataStream.index_pattern).join(',')) || 'logs-*';
    const {
      esqlQuery,
      comments
    } = await translateSplToEsql({
      title: state.original_rule.title,
      taskDescription: _translate_spl_to_esql.TASK_DESCRIPTION.migrate_rule,
      description: state.original_rule.description,
      inlineQuery: state.inline_query,
      indexPattern: indexPatterns
    });
    if (!esqlQuery) {
      return {
        comments
      };
    }
    return {
      elastic_rule: {
        query: esqlQuery,
        query_language: 'esql',
        risk_score: (0, _severity.getElasticRiskScoreFromOriginalRule)(state.original_rule),
        severity: (0, _severity.getElasticSeverityFromOriginalRule)(state.original_rule),
        ...(((_state$integration2 = state.integration) === null || _state$integration2 === void 0 ? void 0 : _state$integration2.id) && {
          integration_ids: [state.integration.id]
        })
      },
      comments
    };
  };
};
exports.getTranslateRuleNode = getTranslateRuleNode;