"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTranslateQueryNode = void 0;
var _translate_spl_to_esql = require("../../../../../../../common/task/agent/helpers/translate_spl_to_esql");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTranslateQueryNode = params => {
  const translateSplToEsql = (0, _translate_spl_to_esql.getTranslateSplToEsql)(params);
  return async state => {
    if (!state.inline_query) {
      return {};
    }
    const description = `Dashboard description: "${state.dashboard_description}"
Specific Panel description: "${state.description}"`;
    const {
      esqlQuery,
      comments
    } = await translateSplToEsql({
      title: state.parsed_panel.title,
      description,
      taskDescription: _translate_spl_to_esql.TASK_DESCRIPTION.migrate_dashboard,
      inlineQuery: state.inline_query,
      indexPattern: _constants.TRANSLATION_INDEX_PATTERN
    });
    if (!esqlQuery) {
      return {
        comments
      };
    }
    return {
      esql_query: esqlQuery,
      comments
    };
  };
};
exports.getTranslateQueryNode = getTranslateQueryNode;