"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMonitoringEntitySourceRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../../common/constants");
var _entity_analytics = require("../../../../../../common/api/entity_analytics");
var _assert_advanced_setting_enabled = require("../../../utils/assert_advanced_setting_enabled");
/* eslint-disable @kbn/eslint/require-license-header */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMonitoringEntitySourceRoute = (router, logger, config) => {
  router.versioned.get({
    access: 'public',
    path: `${_constants.MONITORING_ENTITY_SOURCE_URL}/{id}`,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        params: _entity_analytics.GetEntitySourceRequestParams
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      await (0, _assert_advanced_setting_enabled.assertAdvancedSettingsEnabled)(await context.core, _constants.ENABLE_PRIVILEGED_USER_MONITORING_SETTING);
      const secSol = await context.securitySolution;
      const client = secSol.getMonitoringEntitySourceDataClient();
      const body = await client.get(request.params.id);
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error getting monitoring entity source sync config: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.getMonitoringEntitySourceRoute = getMonitoringEntitySourceRoute;