"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIntegrationsSyncService = void 0;
var _sources_sync = require("../sources_sync");
var _update_detection = require("./update_detection/update_detection");
var _deletion_detection = require("./deletion_detection/deletion_detection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createIntegrationsSyncService = (dataClient, soClient) => {
  const updateDetectionService = (0, _update_detection.createUpdateDetectionService)(dataClient, soClient);
  const sourcesSyncService = (0, _sources_sync.createSourcesSyncService)(dataClient);
  const deletionDetectionService = (0, _deletion_detection.createDeletionDetectionService)(dataClient, soClient);
  const integrationsSync = async () => {
    await sourcesSyncService.syncBySourceType({
      soClient,
      sourceType: 'entity_analytics_integration',
      process: async source => {
        // process each integration source
        await updateDetectionService.updateDetection(source);
        await deletionDetectionService.deletionDetection(source);
      }
    });
  };
  return {
    integrationsSync
  };
};
exports.createIntegrationsSyncService = createIntegrationsSyncService;