"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrebuiltRulesStatusRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _utils = require("../../../routes/utils");
var _prebuilt_rule_assets_client = require("../../logic/rule_assets/prebuilt_rule_assets_client");
var _prebuilt_rule_objects_client = require("../../logic/rule_objects/prebuilt_rule_objects_client");
var _utils2 = require("../../logic/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPrebuiltRulesStatusRoute = router => {
  router.versioned.get({
    access: 'internal',
    path: _prebuilt_rules.GET_PREBUILT_RULES_STATUS_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: '1',
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const ctx = await context.resolve(['core', 'alerting', 'securitySolution']);
      const soClient = ctx.core.savedObjects.client;
      const rulesClient = await ctx.alerting.getRulesClient();
      const ruleAssetsClient = (0, _prebuilt_rule_assets_client.createPrebuiltRuleAssetsClient)(soClient);
      const ruleObjectsClient = (0, _prebuilt_rule_objects_client.createPrebuiltRuleObjectsClient)(rulesClient);
      const mlAuthz = ctx.securitySolution.getMlAuthz();
      const currentRuleVersions = await ruleObjectsClient.fetchInstalledRuleVersions();
      const latestRuleVersions = await ruleAssetsClient.fetchLatestVersions();
      const currentRuleVersionsMap = new Map(currentRuleVersions.map(rule => [rule.rule_id, rule]));
      const latestRuleVersionsMap = new Map(latestRuleVersions.map(rule => [rule.rule_id, rule]));
      const allInstallableRules = latestRuleVersions.filter(rule => !currentRuleVersionsMap.has(rule.rule_id));
      const installableRuleAssets = await (0, _utils2.excludeLicenseRestrictedRules)(allInstallableRules, mlAuthz);
      const upgradableRules = await (0, _utils2.getPossibleUpgrades)(currentRuleVersions, latestRuleVersionsMap, mlAuthz);
      const upgradeableRulesTags = upgradableRules.reduce((tags, rule) => {
        var _currentRuleVersionsM;
        const ruleTags = (_currentRuleVersionsM = currentRuleVersionsMap.get(rule.rule_id)) === null || _currentRuleVersionsM === void 0 ? void 0 : _currentRuleVersionsM.tags;
        if (ruleTags) {
          tags.push(...ruleTags);
        }
        return tags;
      }, []);
      const body = {
        stats: {
          num_prebuilt_rules_installed: currentRuleVersions.length,
          num_prebuilt_rules_to_install: installableRuleAssets.length,
          num_prebuilt_rules_to_upgrade: upgradableRules.length,
          num_prebuilt_rules_total_in_package: latestRuleVersions.length
        },
        aggregated_fields: {
          upgradeable_rules: {
            tags: [...new Set(upgradeableRulesTags)]
          }
        }
      };
      return response.ok({
        body
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getPrebuiltRulesStatusRoute = getPrebuiltRulesStatusRoute;