"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteAssetInventoryRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../common/api/asset_inventory/constants");
var _constants2 = require("../../../../common/constants");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteAssetInventoryRoute = (router, logger) => {
  router.versioned.delete({
    access: 'public',
    path: _constants.ASSET_INVENTORY_DELETE_API_PATH,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.public.v1,
    // TODO: create validation
    validate: false
  }, async (context, _request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const secSol = await context.securitySolution;
      const body = await secSol.getAssetInventoryClient().delete();
      return response.ok({
        body
      });
    } catch (e) {
      if (e instanceof Error && e.message === 'uiSetting') {
        return (0, _errors.errorInactiveFeature)(response);
      }
      logger.error('Error in DeleteEntityEngine:', e);
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.deleteAssetInventoryRoute = deleteAssetInventoryRoute;