"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeProtectionUpdatesNote = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _pMap = _interopRequireDefault(require("p-map"));
var _common2 = require("@kbn/spaces-plugin/common");
var _stringify = require("../../endpoint/utils/stringify");
var _utils = require("../../endpoint/utils");
var _saved_object_mappings = require("../../endpoint/lib/protection_updates_note/saved_object_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const removeProtectionUpdatesNote = async (endpointServices, policy) => {
  const logger = endpointServices.createLogger('removeProtectionUpdatesNote');
  logger.debug(`Processing policy [${policy.id}]`);
  const isSpacesEnabled = endpointServices.experimentalFeatures.endpointManagementSpaceAwarenessEnabled;
  const soClient = isSpacesEnabled ? endpointServices.savedObjects.createInternalUnscopedSoClient(false) : endpointServices.savedObjects.createInternalScopedSoClient({
    readonly: false
  });
  if (policy.id) {
    const foundProtectionUpdatesNotes = await soClient.find({
      type: _saved_object_mappings.protectionUpdatesNoteSavedObjectType,
      hasReference: {
        type: _common.PACKAGE_POLICY_SAVED_OBJECT_TYPE,
        id: policy.id
      },
      namespaces: isSpacesEnabled ? ['*'] : undefined
    }).catch(_utils.catchAndWrapError.withMessage(`Attempt to find [${_saved_object_mappings.protectionUpdatesNoteSavedObjectType}] saved objects referencing policy [${policy.id}] failed`));
    logger.debug(`Found [${foundProtectionUpdatesNotes.total}] saved objects referencing [${policy.id}]`);
    await (0, _pMap.default)(foundProtectionUpdatesNotes.saved_objects, protectionUpdatesNote => {
      var _protectionUpdatesNot, _protectionUpdatesNot2;
      logger.debug(() => `Deleting protections note:\n${(0, _stringify.stringify)(protectionUpdatesNote)}`);
      const soClientForUpdate = isSpacesEnabled ? endpointServices.savedObjects.createInternalScopedSoClient({
        spaceId: (_protectionUpdatesNot = (_protectionUpdatesNot2 = protectionUpdatesNote.namespaces) === null || _protectionUpdatesNot2 === void 0 ? void 0 : _protectionUpdatesNot2.at(0)) !== null && _protectionUpdatesNot !== void 0 ? _protectionUpdatesNot : _common2.DEFAULT_SPACE_ID,
        readonly: false
      }) : soClient;
      return soClientForUpdate.delete(_saved_object_mappings.protectionUpdatesNoteSavedObjectType, protectionUpdatesNote.id, {
        // Force delete across all spaces
        force: true
      }).catch(_utils.catchAndWrapError.withMessage(`Attempt to delete SO [${_saved_object_mappings.protectionUpdatesNoteSavedObjectType}][${protectionUpdatesNote.id}] failed`));
    });
  }
  logger.debug(`Done processing policy [${policy.id}]`);
};
exports.removeProtectionUpdatesNote = removeProtectionUpdatesNote;