"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDataView = exports.StatefulSearchOrFilter = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _public = require("@kbn/unified-search-plugin/public");
var _eui = require("@elastic/eui");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_selector = require("../../../../common/hooks/use_selector");
var _kibana = require("../../../../common/lib/kibana");
var _model = require("../../../../sourcerer/store/model");
var _store = require("../../../../common/store");
var _store2 = require("../../../store");
var _defaults = require("../../../store/defaults");
var _super_date_picker = require("../../../../common/components/super_date_picker");
var _search_or_filter = require("./search_or_filter");
var _actions = require("../../../store/actions");
var _helpers = require("../helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _containers = require("../../../../sourcerer/containers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/search_or_filter/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isDataView = obj => obj != null && typeof obj === 'object' && Object.hasOwn(obj, 'getName');
exports.isDataView = isDataView;
const StatefulSearchOrFilterComponent = /*#__PURE__*/_react.default.memo(({
  dataProviders,
  filters,
  filterManager,
  filterQuery,
  from,
  fromStr,
  isRefreshPaused,
  kqlMode,
  refreshInterval,
  savedQueryId,
  setFilters,
  setSavedQueryId,
  timelineId,
  to,
  toStr,
  updateKqlMode,
  updateReduxTime,
  timelineType
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const [dataView, setDataView] = (0, _react.useState)();
  const {
    services: {
      data
    }
  } = (0, _kibana.useKibana)();
  const {
    sourcererDataView: dataViewSpec
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.timeline);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const getIsDataProviderVisible = (0, _react.useMemo)(() => _store2.timelineSelectors.dataProviderVisibilitySelector(), []);
  const isDataProviderVisible = (0, _use_selector.useDeepEqualSelector)(state => getIsDataProviderVisible(state, timelineId));
  (0, _react.useEffect)(() => {
    // TODO: (new data view picker) - this should not be necessary since the data view creation is managed in a centralized location
    // with the new picker - eg. top level of the app, in data view picker state listener.
    if (newDataViewPickerEnabled) {
      return;
    }
    let dv;
    const createDataView = async () => {
      try {
        dv = await data.dataViews.create(dataViewSpec);
        setDataView(dv);
      } catch (error) {
        addError(error, {
          title: i18n.ERROR_PROCESSING_INDEX_PATTERNS
        });
      }
    };
    createDataView();
    return () => {
      var _dv;
      if ((_dv = dv) !== null && _dv !== void 0 && _dv.id) {
        var _dv2;
        data.dataViews.clearInstanceCache((_dv2 = dv) === null || _dv2 === void 0 ? void 0 : _dv2.id);
      }
    };
  }, [data.dataViews, filterQuery, addError, dataViewSpec, newDataViewPickerEnabled]);

  // NOTE: re-using data view that is already created and available through data view manager
  const arrDataView = (0, _react.useMemo)(() => {
    if (newDataViewPickerEnabled) {
      return experimentalDataView ? [experimentalDataView] : [];
    }
    return dataView != null ? [dataView] : [];
  }, [dataView, experimentalDataView, newDataViewPickerEnabled]);

  // Keep filter manager in sync with redux filters
  (0, _react.useEffect)(() => {
    if (!(0, _fastDeepEqual.default)(filterManager.getFilters(), filters)) {
      filterManager.setFilters(filters);
    }
  }, [filterManager, filters]);

  // When a filter update comes in through the filter manager, update redux
  (0, _react.useEffect)(() => {
    const subscription = filterManager.getUpdates$().subscribe(() => {
      const filtersWithoutDropArea = (0, _helpers.getNonDropAreaFilters)(filterManager.getFilters());
      if (!(0, _fastDeepEqual.default)(filtersWithoutDropArea, filters)) {
        setFilters({
          id: timelineId,
          filters: filtersWithoutDropArea
        });
      }
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [filterManager, timelineId, setFilters, filters]);

  // Sync redux filters with updated from <FilterItems />
  const onFiltersUpdated = (0, _react.useCallback)(newFilters => {
    setFilters({
      id: timelineId,
      filters: newFilters
    });
  }, [timelineId, setFilters]);
  const setSavedQueryInTimeline = (0, _react.useCallback)(newSavedQueryId => setSavedQueryId({
    id: timelineId,
    savedQueryId: newSavedQueryId
  }), [timelineId, setSavedQueryId]);
  const toggleDataProviderVisibility = (0, _react.useCallback)(() => {
    dispatch((0, _actions.setDataProviderVisibility)({
      id: timelineId,
      isDataProviderVisible: !isDataProviderVisible
    }));
  }, [isDataProviderVisible, timelineId, dispatch]);
  (0, _react.useEffect)(() => {
    /*
     * If there is a change in data providers
     *    - data provider has some data and it was hidden,
     *        * it must be made visible
     *
     *    - data provider has no data and it was visible,
     *        * it must be hidden
     *
     * */
    if ((dataProviders === null || dataProviders === void 0 ? void 0 : dataProviders.length) > 0) {
      dispatch((0, _actions.setDataProviderVisibility)({
        id: timelineId,
        isDataProviderVisible: true
      }));
    } else if ((dataProviders === null || dataProviders === void 0 ? void 0 : dataProviders.length) === 0) {
      dispatch((0, _actions.setDataProviderVisibility)({
        id: timelineId,
        isDataProviderVisible: false
      }));
    }
  }, [dataProviders, dispatch, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "eui-scrollBar",
    direction: "row",
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_search_or_filter.SearchOrFilter, {
    dataProviders: dataProviders,
    filters: filters,
    filterManager: filterManager,
    filterQuery: filterQuery,
    from: from,
    fromStr: fromStr,
    isRefreshPaused: isRefreshPaused,
    kqlMode: kqlMode,
    refreshInterval: refreshInterval,
    savedQueryId: savedQueryId,
    setSavedQueryId: setSavedQueryInTimeline,
    timelineId: timelineId,
    to: to,
    toStr: toStr,
    updateKqlMode: updateKqlMode,
    updateReduxTime: updateReduxTime,
    toggleDataProviderVisibility: toggleDataProviderVisibility,
    isDataProviderVisible: isDataProviderVisible,
    timelineType: timelineType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  })))), filters && filters.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "timeline-filters-container",
    direction: "row",
    gutterSize: "xs",
    wrap: true,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_public.FilterItems, {
    filters: filters,
    onFiltersUpdated: onFiltersUpdated,
    indexPatterns: arrDataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 15
    }
  }))) : null);
}, (prevProps, nextProps) => {
  return prevProps.filterManager === nextProps.filterManager && prevProps.from === nextProps.from && prevProps.fromStr === nextProps.fromStr && prevProps.to === nextProps.to && prevProps.toStr === nextProps.toStr && prevProps.isRefreshPaused === nextProps.isRefreshPaused && prevProps.refreshInterval === nextProps.refreshInterval && prevProps.timelineId === nextProps.timelineId && (0, _fastDeepEqual.default)(prevProps.dataProviders, nextProps.dataProviders) && (0, _fastDeepEqual.default)(prevProps.filters, nextProps.filters) && (0, _fastDeepEqual.default)(prevProps.filterQuery, nextProps.filterQuery) && (0, _fastDeepEqual.default)(prevProps.kqlMode, nextProps.kqlMode) && (0, _fastDeepEqual.default)(prevProps.savedQueryId, nextProps.savedQueryId) && (0, _fastDeepEqual.default)(prevProps.timelineId, nextProps.timelineId) && prevProps.timelineType === nextProps.timelineType;
});
StatefulSearchOrFilterComponent.displayName = 'StatefulSearchOrFilterComponent';
const makeMapStateToProps = () => {
  const getTimeline = _store2.timelineSelectors.getTimelineByIdSelector();
  const getKqlFilterQuery = _store2.timelineSelectors.getKqlFilterKuerySelector();
  const getInputsTimeline = _store.inputsSelectors.getTimelineSelector();
  const getInputsPolicy = _store.inputsSelectors.getTimelinePolicySelector();
  const mapStateToProps = (state, {
    timelineId
  }) => {
    var _getTimeline;
    const timeline = (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
    const input = getInputsTimeline(state);
    const policy = getInputsPolicy(state);
    return {
      dataProviders: timeline.dataProviders,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      filterQuery: getKqlFilterQuery(state, timelineId),
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      filters: timeline.filters,
      from: input.timerange.from,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      fromStr: input.timerange.fromStr,
      isRefreshPaused: policy.kind === 'manual',
      kqlMode: (0, _fp.getOr)('filter', 'kqlMode', timeline),
      refreshInterval: policy.duration,
      savedQueryId: (0, _fp.getOr)(null, 'savedQueryId', timeline),
      to: input.timerange.to,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      toStr: input.timerange.toStr,
      timelineType: timeline.timelineType
    };
  };
  return mapStateToProps;
};
const mapDispatchToProps = dispatch => ({
  updateKqlMode: ({
    id,
    kqlMode
  }) => dispatch(_store2.timelineActions.updateKqlMode({
    id,
    kqlMode
  })),
  setSavedQueryId: ({
    id,
    savedQueryId
  }) => dispatch(_store2.timelineActions.setSavedQueryId({
    id,
    savedQueryId
  })),
  setFilters: ({
    id,
    filters
  }) => dispatch(_store2.timelineActions.setFilters({
    id,
    filters
  })),
  updateReduxTime: (0, _super_date_picker.dispatchUpdateReduxTime)(dispatch)
});
const connector = (0, _reactRedux.connect)(makeMapStateToProps, mapDispatchToProps);
const StatefulSearchOrFilter = exports.StatefulSearchOrFilter = connector(StatefulSearchOrFilterComponent);