"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineKpisContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _reactRedux = require("react-redux");
var _common = require("@kbn/data-plugin/common");
var _eui = require("@elastic/eui");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_browser_fields = require("../../../../data_view_manager/hooks/use_browser_fields");
var _types = require("../../../../../common/types");
var _use_selector = require("../../../../common/hooks/use_selector");
var _containers = require("../../../../sourcerer/containers");
var _model = require("../../../../sourcerer/store/model");
var _kpis = require("./kpis");
var _kpis2 = require("../../../containers/kpis");
var _kibana = require("../../../../common/lib/kibana");
var _store = require("../../../store");
var _defaults = require("../../../store/defaults");
var _kuery = require("../../../../common/lib/kuery");
var _selectors = require("../../../../common/components/super_date_picker/selectors");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/kpi/kpi_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimelineKpisContainer = ({
  timelineId
}) => {
  var _combinedQueries$filt;
  const {
    newDataViewPickerEnabled
  } = (0, _use_experimental_features.useEnableExperimental)();
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(_model.SourcererScopeName.timeline);
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.timeline);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_model.SourcererScopeName.timeline);
  const {
    browserFields: oldBrowserFields,
    sourcererDataView: oldSourcererDataViewSpec,
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const browserFields = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields, [experimentalBrowserFields, newDataViewPickerEnabled, oldBrowserFields]);
  const selectedPatterns = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns, [experimentalSelectedPatterns, newDataViewPickerEnabled, oldSelectedPatterns]);
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const {
    dataProviders,
    filters,
    kqlMode
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return (0, _fp.pick)(['dataProviders', 'filters', 'kqlMode'], (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults);
  });
  const getKqlQueryTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getKqlFilterQuerySelector(), []);
  const kqlQueryTimeline = (0, _reactRedux.useSelector)(state => getKqlQueryTimeline(state, timelineId));
  const kqlQueryExpression = kqlQueryTimeline !== null && kqlQueryTimeline !== void 0 ? kqlQueryTimeline : ' ';
  const kqlQuery = (0, _react.useMemo)(() => ({
    query: kqlQueryExpression,
    language: 'kuery'
  }), [kqlQueryExpression]);
  const isActive = (0, _react.useMemo)(() => timelineId === _types.TimelineId.active, [timelineId]);
  const getStartSelector = (0, _react.useMemo)(() => (0, _selectors.startSelector)(), []);
  const getEndSelector = (0, _react.useMemo)(() => (0, _selectors.endSelector)(), []);
  const timerange = (0, _use_selector.useDeepEqualSelector)(state => {
    if (isActive) {
      return {
        from: getStartSelector(state.inputs.timeline),
        to: getEndSelector(state.inputs.timeline),
        interval: ''
      };
    } else {
      return {
        from: getStartSelector(state.inputs.global),
        to: getEndSelector(state.inputs.global),
        interval: ''
      };
    }
  });
  const combinedQueries = (0, _react.useMemo)(() => (0, _kuery.combineQueries)({
    config: esQueryConfig,
    dataProviders,
    dataViewSpec: oldSourcererDataViewSpec,
    dataView: experimentalDataView,
    browserFields,
    filters: filters ? filters : [],
    kqlQuery,
    kqlMode
  }), [esQueryConfig, dataProviders, oldSourcererDataViewSpec, experimentalDataView, browserFields, filters, kqlQuery, kqlMode]);
  const isBlankTimeline = (0, _react.useMemo)(() => (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)(filters) && (0, _fp.isEmpty)(kqlQuery.query) || (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) === undefined, [dataProviders, filters, kqlQuery, combinedQueries]);
  const [, kpis] = (0, _kpis2.useTimelineKpis)({
    defaultIndex: selectedPatterns,
    timerange,
    isBlankTimeline,
    filterQuery: (_combinedQueries$filt = combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) !== null && _combinedQueries$filt !== void 0 ? _combinedQueries$filt : ''
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_kpis.TimelineKPIs, {
    kpis: kpis,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }));
};
exports.TimelineKpisContainer = TimelineKpisContainer;