"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuricataDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _netflow = require("../netflow");
var _suricata_signature = require("./suricata_signature");
var _suricata_refs = require("./suricata_refs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/suricata/suricata_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Details = _styledComponents.default.div`
  margin: 5px 0;
`;
Details.displayName = 'Details';
const SuricataDetails = exports.SuricataDetails = /*#__PURE__*/_react.default.memo(({
  data,
  timelineId
}) => {
  const signature = (0, _fp.get)('suricata.eve.alert.signature[0]', data);
  const signatureId = (0, _fp.get)('suricata.eve.alert.signature_id[0]', data);
  if (signatureId != null && signature != null) {
    return /*#__PURE__*/_react.default.createElement(Details, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_suricata_signature.SuricataSignature, {
      contextId: `suricata-signature-${timelineId}-${data._id}`,
      id: data._id,
      signature: signature,
      signatureId: signatureId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_suricata_refs.SuricataRefs, {
      signatureId: signatureId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_netflow.NetflowRenderer, {
      data: data,
      timelineId: timelineId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }));
  } else {
    return null;
  }
});
SuricataDetails.displayName = 'SuricataDetails';