"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSourcererDataView = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _sourcerer = require("../../../common/utils/sourcerer");
var _constants = require("../../../common/constants");
var _translations = require("../../data_view_manager/components/data_view_picker/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line complexity
const createSourcererDataView = async ({
  body,
  dataViewService,
  dataViewId,
  alertDataViewId,
  signalIndexName
}) => {
  if (dataViewId === null) {
    return;
  }
  let allDataViews = await dataViewService.getIdsWithTitle();
  const siemDataViewExist = allDataViews.find(dv => dv.id === dataViewId);
  const alertDataViewExist = allDataViews.find(dv => dv.id === alertDataViewId);
  const {
    patternList
  } = body;
  const patternListFormatted = (0, _sourcerer.ensurePatternFormat)(patternList);
  const patternListAsTitle = patternListFormatted.join();
  let siemDataView;
  let defaultDataView;
  if (siemDataViewExist === undefined) {
    var _siemDataView$id;
    try {
      siemDataView = await dataViewService.createAndSave({
        allowNoIndex: true,
        id: dataViewId,
        title: patternListAsTitle,
        timeFieldName: _constants.DEFAULT_TIME_FIELD,
        name: _translations.DEFAULT_SECURITY_DATA_VIEW
      },
      // Override property - if a data view exists with the security solution pattern
      // delete it and replace it with our data view
      true);
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      if (err.name === 'DuplicateDataViewError' || error.statusCode === 409) {
        siemDataView = await dataViewService.get(dataViewId);
      } else {
        throw error;
      }
    }
    defaultDataView = {
      id: (_siemDataView$id = siemDataView.id) !== null && _siemDataView$id !== void 0 ? _siemDataView$id : dataViewId,
      patternList: siemDataView.title.split(','),
      title: siemDataView.title
    };
  } else {
    let patterns = (0, _sourcerer.ensurePatternFormat)(siemDataViewExist.title.split(','));
    const siemDataViewTitle = siemDataViewExist ? patterns.join() : '';
    const arePatternsDifferent = patternListAsTitle !== siemDataViewTitle;
    const isDefaultDataViewName = siemDataViewExist.name === _translations.DEFAULT_SECURITY_DATA_VIEW;

    // Update the saved object if the pattern list is different or the name is incorrect
    if (arePatternsDifferent || !isDefaultDataViewName) {
      siemDataView = await dataViewService.get(dataViewId);
      if (arePatternsDifferent) {
        patterns = patternListFormatted;
        siemDataView.title = patternListAsTitle;
      }
      if (!isDefaultDataViewName) {
        siemDataView.name = _translations.DEFAULT_SECURITY_DATA_VIEW;
      }
      await dataViewService.updateSavedObject(siemDataView);
    }
    defaultDataView = {
      id: dataViewId,
      patternList: patterns,
      title: patternListAsTitle
    };
  }
  let alertOnlyDataView;
  let alertDataView;
  if (signalIndexName && alertDataViewId && alertDataViewExist === undefined) {
    var _alertOnlyDataView$id;
    try {
      alertOnlyDataView = await dataViewService.createAndSave({
        allowNoIndex: true,
        id: alertDataViewId,
        title: signalIndexName,
        timeFieldName: _constants.DEFAULT_TIME_FIELD,
        name: _translations.DEFAULT_SECURITY_ALERT_DATA_VIEW,
        managed: true
      },
      // Override property - if a data view exists with the security solution pattern
      // delete it and replace it with our data view
      true);
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      if (err.name === 'DuplicateDataViewError' || error.statusCode === 409) {
        alertOnlyDataView = await dataViewService.get(alertDataViewId);
      } else {
        throw error;
      }
    }
    alertDataView = {
      id: (_alertOnlyDataView$id = alertOnlyDataView.id) !== null && _alertOnlyDataView$id !== void 0 ? _alertOnlyDataView$id : alertDataViewId,
      patternList: alertOnlyDataView.title.split(','),
      title: alertOnlyDataView.title
    };
  } else {
    // Update the saved object if the name is incorrect
    if (alertDataViewId && (alertDataViewExist === null || alertDataViewExist === void 0 ? void 0 : alertDataViewExist.name) !== _translations.DEFAULT_SECURITY_ALERT_DATA_VIEW) {
      siemDataView = await dataViewService.get(alertDataViewId);
      siemDataView.name = _translations.DEFAULT_SECURITY_ALERT_DATA_VIEW;
      await dataViewService.updateSavedObject(siemDataView);
    }
    alertDataView = {
      id: alertDataViewId !== null && alertDataViewId !== void 0 ? alertDataViewId : '',
      patternList: signalIndexName ? [signalIndexName] : [],
      title: signalIndexName !== null && signalIndexName !== void 0 ? signalIndexName : ''
    };
  }
  if (allDataViews.some(dv => dv.id === dataViewId)) {
    allDataViews = allDataViews.map(v => v.id === dataViewId ? {
      ...v,
      title: patternListAsTitle
    } : v);
  } else if (defaultDataView !== null) {
    var _defaultDataView$id, _defaultDataView;
    allDataViews.push({
      id: (_defaultDataView$id = defaultDataView.id) !== null && _defaultDataView$id !== void 0 ? _defaultDataView$id : dataViewId,
      title: (_defaultDataView = defaultDataView) === null || _defaultDataView === void 0 ? void 0 : _defaultDataView.title
    });
  }
  const existingPatternList = await dataViewService.getExistingIndices(defaultDataView.patternList);
  defaultDataView = {
    ...defaultDataView,
    patternList: existingPatternList
  };
  return {
    defaultDataView,
    kibanaDataViews: allDataViews.map(dv => dv.id === dataViewId ? defaultDataView : {
      id: dv.id,
      patternList: dv.title.split(','),
      title: dv.title
    }),
    alertDataView
  };
};
exports.createSourcererDataView = createSourcererDataView;