"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrationRuleDetailsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/siem_migrations/constants");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _rule_overview_tab = require("../../../../detection_engine/rule_management/components/rule_details/rule_overview_tab");
var logicI18n = _interopRequireWildcard(require("../../logic/translations"));
var i18n = _interopRequireWildcard(require("./translations"));
var _constants2 = require("./constants");
var _tabs = require("./tabs");
var _utils = require("../../../../../common/siem_migrations/rules/utils");
var _use_update_migration_rule = require("../../logic/use_update_migration_rule");
var _utils2 = require("../../../common/components/details_flyout/utils");
var _translation = require("../../../common/components/details_flyout/translation");
var _updated_by_label = require("../../../common/components/updated_by_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rule_details_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MigrationRuleDetailsFlyout = exports.MigrationRuleDetailsFlyout = /*#__PURE__*/_react.default.memo(({
  ruleActions,
  migrationRule,
  matchedPrebuiltRule,
  size = 'm',
  extraTabs = [],
  isDataLoading,
  closeFlyout
}) => {
  var _tabs$find, _ref, _ruleDetailsToOvervie, _migrationRule$update, _migrationRule$update2;
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    expandedOverviewSections,
    toggleOverviewSection
  } = (0, _rule_overview_tab.useOverviewTabSections)();
  const {
    mutateAsync: updateMigrationRule
  } = (0, _use_update_migration_rule.useUpdateMigrationRule)(migrationRule);
  const [isUpdating, setIsUpdating] = (0, _react.useState)(false);
  const isLoading = isDataLoading || isUpdating;
  const handleTranslationUpdate = (0, _react.useCallback)(async (ruleName, ruleQuery) => {
    if (isLoading) {
      return;
    }
    setIsUpdating(true);
    try {
      await updateMigrationRule({
        id: migrationRule.id,
        elastic_rule: {
          title: ruleName,
          query: ruleQuery,
          query_language: 'esql'
        }
      });
    } catch (error) {
      addError(error, {
        title: logicI18n.UPDATE_MIGRATION_RULES_FAILURE
      });
    } finally {
      setIsUpdating(false);
    }
  }, [isLoading, updateMigrationRule, migrationRule, addError]);
  const ruleDetailsToOverview = (0, _react.useMemo)(() => {
    const elasticRule = migrationRule === null || migrationRule === void 0 ? void 0 : migrationRule.elastic_rule;
    if ((0, _utils.isMigrationCustomRule)(elasticRule)) {
      return (0, _utils.convertMigrationCustomRuleToSecurityRulePayload)(elasticRule, false);
    }
    return matchedPrebuiltRule;
  }, [migrationRule, matchedPrebuiltRule]);
  const translationTab = (0, _react.useMemo)(() => ({
    id: 'translation',
    name: i18n.TRANSLATION_TAB_LABEL,
    'data-test-subj': 'tabTranslation',
    content: /*#__PURE__*/_react.default.createElement(_utils2.TabContentPadding, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_tabs.TranslationTab, {
      migrationRule: migrationRule,
      matchedPrebuiltRule: matchedPrebuiltRule,
      onTranslationUpdate: handleTranslationUpdate,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 13
      }
    }))
  }), [migrationRule, handleTranslationUpdate, matchedPrebuiltRule]);
  const overviewTab = (0, _react.useMemo)(() => ({
    id: 'overview',
    name: i18n.OVERVIEW_TAB_LABEL,
    'data-test-subj': 'tabOverview',
    content: /*#__PURE__*/_react.default.createElement(_utils2.TabContentPadding, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 11
      }
    }, ruleDetailsToOverview && /*#__PURE__*/_react.default.createElement(_rule_overview_tab.RuleOverviewTab, {
      rule: ruleDetailsToOverview,
      columnWidths: size === 'l' ? _constants2.LARGE_DESCRIPTION_LIST_COLUMN_WIDTHS : _constants2.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
      expandedOverviewSections: expandedOverviewSections,
      toggleOverviewSection: toggleOverviewSection,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 15
      }
    })),
    disabled: migrationRule.translation_result === _constants.MigrationTranslationResult.UNTRANSLATABLE
  }), [ruleDetailsToOverview, size, expandedOverviewSections, toggleOverviewSection, migrationRule.translation_result]);
  const summaryTab = (0, _react.useMemo)(() => ({
    id: 'summary',
    name: _translation.SUMMARY_TAB_LABEL,
    'data-test-subj': 'tabSummary',
    content: /*#__PURE__*/_react.default.createElement(_utils2.TabContentPadding, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_tabs.SummaryTab, {
      migrationRule: migrationRule,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 13
      }
    }))
  }), [migrationRule]);
  const tabs = (0, _react.useMemo)(() => {
    return [...extraTabs, translationTab, overviewTab, summaryTab];
  }, [extraTabs, translationTab, overviewTab, summaryTab]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(tabs[0].id);
  const selectedTab = (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  (0, _react.useEffect)(() => {
    if (!tabs.find(tab => tab.id === selectedTabId)) {
      // Switch to first tab if currently selected tab is not available for this rule
      setSelectedTabId(tabs[0].id);
    }
  }, [tabs, selectedTabId]);
  const onTabClick = tab => {
    setSelectedTabId(tab.id);
  };
  const tabsContent = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_utils2.ScrollableFlyoutTabbedContent, {
      tabs: tabs,
      selectedTab: selectedTab,
      onTabClick: onTabClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 9
      }
    });
  }, [selectedTab, tabs]);
  const migrationsRulesFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'migrationRulesFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: size,
    onClose: closeFlyout,
    key: "migrations-rules-flyout",
    paddingSize: "l",
    "data-test-subj": "ruleMigrationDetailsFlyout",
    "aria-labelledby": migrationsRulesFlyoutTitleId,
    ownFocus: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "detailsFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: migrationsRulesFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }, (_ref = (_ruleDetailsToOvervie = ruleDetailsToOverview === null || ruleDetailsToOverview === void 0 ? void 0 : ruleDetailsToOverview.name) !== null && _ruleDetailsToOvervie !== void 0 ? _ruleDetailsToOvervie : migrationRule.original_rule.title) !== null && _ref !== void 0 ? _ref : i18n.UNKNOWN_MIGRATION_RULE_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_updated_by_label.UpdatedByLabel, {
    updatedBy: (_migrationRule$update = migrationRule.updated_by) !== null && _migrationRule$update !== void 0 ? _migrationRule$update : migrationRule.created_by,
    updatedAt: (_migrationRule$update2 = migrationRule.updated_at) !== null && _migrationRule$update2 !== void 0 ? _migrationRule$update2 : migrationRule['@timestamp'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody
  // EUI TODO: We need to set transform to 'none' to avoid drag/drop issues in the flyout caused by the
  // `transform: translateZ(0)` workaround for the mask image bug in Chromium.
  // https://github.com/elastic/eui/pull/7855.
  // We need to remove this workaround once it is fixed in EUI:
  // https://github.com/elastic/eui/issues/8269.
  , {
    css: {
      '.euiFlyoutBody__overflow': {
        transform: 'none'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 17
      }
    })),
    loadedContent: tabsContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    flush: "left",
    "data-test-subj": "detailsFlyoutCloseButton",
    "aria-label": _translation.CLOSE_BUTTON_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 15
    }
  }, _translation.CLOSE_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 13
    }
  }, ruleActions))));
});
MigrationRuleDetailsFlyout.displayName = 'MigrationRuleDetailsFlyout';