"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartTranslationButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/common/components/start_translation_button/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StartTranslationButton = exports.StartTranslationButton = /*#__PURE__*/_react.default.memo(({
  migrationId,
  isStopped,
  startMigration,
  isStarting
}) => {
  const onStartMigration = (0, _react.useCallback)(() => {
    startMigration(migrationId);
  }, [migrationId, startMigration]);
  const text = (0, _react.useMemo)(() => {
    if (isStopped) {
      return isStarting ? i18n.MIGRATION_RESUMING_TRANSLATION_BUTTON : i18n.MIGRATION_RESUME_TRANSLATION_BUTTON;
    } else {
      return isStarting ? i18n.MIGRATION_STARTING_TRANSLATION_BUTTON : i18n.MIGRATION_START_TRANSLATION_BUTTON;
    }
  }, [isStopped, isStarting]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": 'startMigrationButton',
    "aria-label": text,
    fill: !isStopped,
    onClick: onStartMigration,
    isLoading: isStarting,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, text);
});
StartTranslationButton.displayName = 'StartTranslationButton';