"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LimitWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/limit_warnings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const lineageLimitMessage = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.endpoint.resolver.eitherLineageLimitExceeded",
  defaultMessage: "Some process events in the visualization and event list below could not be displayed because the data limit has been reached.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 13,
    columnNumber: 3
  }
});

// eslint-disable-next-line react/display-name
const LineageTitleMessage = /*#__PURE__*/_react.default.memo(function ({
  numberOfEntries
}) {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.relatedEventLimitTitle",
    defaultMessage: "This list includes {numberOfEntries} process events.",
    values: {
      numberOfEntries
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  });
});

/**
 * Limit warning for hitting a limit of nodes in the tree
 */
// eslint-disable-next-line react/display-name
const LimitWarning = exports.LimitWarning = /*#__PURE__*/_react.default.memo(function ({
  numberDisplayed
}) {
  return /*#__PURE__*/_react.default.createElement(_styles.LimitWarningsEuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(LineageTitleMessage, {
      numberOfEntries: numberDisplayed,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 14
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, lineageLimitMessage));
});