"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _side_effect_context = require("../side_effect_context");
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _use_colors = require("../use_colors");
var _action = require("../../store/camera/action");
var _sourcerer_selection = require("./sourcerer_selection");
var _date_picker = require("./date_picker");
var _styles = require("./styles");
var _legend = require("./legend");
var _schema = require("./schema");
var _show_panel = require("./show_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/controls/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GraphControls = exports.GraphControls = /*#__PURE__*/_react.default.memo(({
  id,
  className,
  isSplitPanel,
  showPanelOnClick
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const scalingFactor = (0, _reactRedux.useSelector)(state => selectors.scalingFactor(state.analyzer[id]));
  const {
    timestamp
  } = (0, _react.useContext)(_side_effect_context.SideEffectContext);
  const [activePopover, setPopover] = (0, _react.useState)(null);
  const colorMap = (0, _use_colors.useColors)();
  const setActivePopover = (0, _react.useCallback)(value => {
    if (value === activePopover) {
      setPopover(null);
    } else {
      setPopover(value);
    }
  }, [setPopover, activePopover]);
  const closePopover = (0, _react.useCallback)(() => setPopover(null), []);
  const handleZoomAmountChange = (0, _react.useCallback)(event => {
    const valueAsNumber = parseFloat(event.target.value);
    if (isNaN(valueAsNumber) === false) {
      dispatch((0, _action.userSetZoomLevel)({
        id,
        zoomLevel: valueAsNumber
      }));
    }
  }, [dispatch, id]);
  const handleCenterClick = (0, _react.useCallback)(() => {
    dispatch((0, _action.userSetPositionOfCamera)({
      id,
      cameraView: [0, 0]
    }));
  }, [dispatch, id]);
  const handleZoomOutClick = (0, _react.useCallback)(() => {
    dispatch((0, _action.userClickedZoomOut)({
      id
    }));
  }, [dispatch, id]);
  const handleZoomInClick = (0, _react.useCallback)(() => {
    dispatch((0, _action.userClickedZoomIn)({
      id
    }));
  }, [dispatch, id]);
  const [handleNorth, handleEast, handleSouth, handleWest] = (0, _react.useMemo)(() => {
    const directionVectors = [[0, 1], [1, 0], [0, -1], [-1, 0]];
    return directionVectors.map(direction => {
      return () => {
        dispatch((0, _action.userNudgedCamera)({
          id,
          direction,
          time: timestamp()
        }));
      };
    });
  }, [dispatch, timestamp, id]);

  /* eslint-disable react/button-has-type */
  return /*#__PURE__*/_react.default.createElement(_styles.StyledGraphControls, {
    className: className,
    $iconColor: colorMap.graphControls,
    "data-test-subj": "resolver:graph-controls",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.StyledGraphControlsColumn, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_schema.SchemaInformation, {
    id: id,
    closePopover: closePopover,
    isOpen: activePopover === 'schemaInfo',
    setActivePopover: setActivePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_legend.NodeLegend, {
    id: id,
    closePopover: closePopover,
    isOpen: activePopover === 'nodeLegend',
    setActivePopover: setActivePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_sourcerer_selection.SourcererButton, {
    id: id,
    closePopover: closePopover,
    isOpen: activePopover === 'sourcererSelection',
    setActivePopover: setActivePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_date_picker.DateSelectionButton, {
    id: id,
    closePopover: closePopover,
    isOpen: activePopover === 'datePicker',
    setActivePopover: setActivePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }), isSplitPanel && showPanelOnClick && /*#__PURE__*/_react.default.createElement(_show_panel.ShowPanelButton, {
    showPanelOnClick: showPanelOnClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_styles.StyledGraphControlsColumn, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "panning-controls",
    paddingSize: "none",
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "panning-controls-top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "north-button",
    "data-test-subj": "resolver:graph-controls:north-button",
    title: _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.north', {
      defaultMessage: 'North'
    }),
    onClick: handleNorth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowUp",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "panning-controls-middle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "west-button",
    "data-test-subj": "resolver:graph-controls:west-button",
    title: _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.west', {
      defaultMessage: 'West'
    }),
    onClick: handleWest,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement("button", {
    className: "center-button",
    "data-test-subj": "resolver:graph-controls:center-button",
    title: _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.center', {
      defaultMessage: 'Center'
    }),
    onClick: handleCenterClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "bullseye",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement("button", {
    className: "east-button",
    "data-test-subj": "resolver:graph-controls:east-button",
    title: _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.east', {
      defaultMessage: 'East'
    }),
    onClick: handleEast,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "panning-controls-bottom",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "south-button",
    "data-test-subj": "resolver:graph-controls:south-button",
    title: _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.south', {
      defaultMessage: 'South'
    }),
    onClick: handleSouth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowDown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "zoom-controls",
    paddingSize: "none",
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("button", {
    title: _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.zoomIn', {
      defaultMessage: 'Zoom In'
    }),
    "data-test-subj": "resolver:graph-controls:zoom-in",
    onClick: handleZoomInClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "plusInCircle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_styles.StyledEuiRange, {
    className: "zoom-slider",
    "data-test-subj": "resolver:graph-controls:zoom-slider",
    min: 0,
    max: 1,
    step: 0.01,
    value: scalingFactor,
    onChange: handleZoomAmountChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement("button", {
    title: _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.zoomOut', {
      defaultMessage: 'Zoom Out'
    }),
    "data-test-subj": "resolver:graph-controls:zoom-out",
    onClick: handleZoomOutClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minusInCircle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 15
    }
  })))));
});
GraphControls.displayName = 'GraphControls';