"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyArtifactsFlyout = exports.MAX_ALLOWED_RESULTS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@kbn/react-query");
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _search_exceptions = require("../../../../../components/search_exceptions");
var _kibana = require("../../../../../../common/lib/kibana");
var _assignable = require("../assignable");
var _artifacts = require("../../../../../hooks/artifacts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/artifacts/flyout/policy_artifacts_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_ALLOWED_RESULTS = exports.MAX_ALLOWED_RESULTS = 100;
const PolicyArtifactsFlyout = exports.PolicyArtifactsFlyout = /*#__PURE__*/_react.default.memo(({
  policyItem,
  apiClient,
  searchableFields,
  onClose,
  labels,
  CardDecorator
}) => {
  const toasts = (0, _kibana.useToasts)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const [selectedArtifactIds, setSelectedArtifactIds] = (0, _react.useState)([]);
  const [currentFilter, setCurrentFilter] = (0, _react.useState)('');
  const bulkUpdateMutation = (0, _artifacts.useBulkUpdateArtifact)(apiClient, {
    onSuccess: updatedExceptions => {
      toasts.addSuccess({
        title: labels.flyoutSuccessMessageTitle,
        text: labels.flyoutSuccessMessageText(updatedExceptions)
      });
      queryClient.invalidateQueries(['list', apiClient]);
      onClose();
    },
    onError: () => {
      toasts.addDanger(labels.flyoutErrorMessage);
    }
  });
  const {
    data: artifacts,
    isLoading: isLoadingArtifacts,
    isRefetching: isRefetchingArtifacts
  } = (0, _artifacts.useListArtifact)(apiClient, {
    perPage: MAX_ALLOWED_RESULTS,
    filter: currentFilter,
    excludedPolicies: [policyItem.id, 'all']
  }, searchableFields);
  const {
    data: allNotAssigned,
    isLoading: isLoadingAllNotAssigned
  } = (0, _artifacts.useListArtifact)(apiClient, {
    excludedPolicies: [policyItem.id, 'all']
  }, searchableFields);
  const handleOnSearch = (0, _react.useCallback)(query => {
    setSelectedArtifactIds([]);
    setCurrentFilter(query);
  }, []);
  const handleOnConfirmAction = (0, _react.useCallback)(() => {
    if (!artifacts) {
      return;
    }
    const artifactsToUpdate = [];
    selectedArtifactIds.forEach(selectedId => {
      const artifact = artifacts.data.find(current => current.id === selectedId);
      if (artifact) {
        artifact.tags = [...artifact.tags, `policy:${policyItem.id}`];
        artifactsToUpdate.push(artifact);
      }
    });
    bulkUpdateMutation.mutate(artifactsToUpdate);
  }, [bulkUpdateMutation, artifacts, policyItem.id, selectedArtifactIds]);
  const handleSelectArtifacts = (artifactId, selected) => {
    setSelectedArtifactIds(currentSelectedArtifactIds => selected ? [...currentSelectedArtifactIds, artifactId] : (0, _fp.without)([artifactId], currentSelectedArtifactIds));
  };
  const searchWarningMessage = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "artifacts-too-many-results",
    color: "warning",
    size: "s",
    heading: "h4",
    title: labels.flyoutWarningCalloutTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, labels.flyoutWarningCalloutMessage(MAX_ALLOWED_RESULTS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  })), [labels]);
  const assignableArtifacts = (0, _react.useMemo)(() => (allNotAssigned === null || allNotAssigned === void 0 ? void 0 : allNotAssigned.total) !== 0 && ((artifacts === null || artifacts === void 0 ? void 0 : artifacts.total) !== 0 || currentFilter !== ''), [allNotAssigned === null || allNotAssigned === void 0 ? void 0 : allNotAssigned.total, artifacts === null || artifacts === void 0 ? void 0 : artifacts.total, currentFilter]);
  const isGlobalLoading = (0, _react.useMemo)(() => isLoadingArtifacts || isRefetchingArtifacts || isLoadingAllNotAssigned, [isLoadingAllNotAssigned, isLoadingArtifacts, isRefetchingArtifacts]);
  const noItemsMessage = (0, _react.useMemo)(() => {
    if (isGlobalLoading) {
      return null;
    }

    // there are no artifacts assignable to this policy
    if (!assignableArtifacts) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        titleSize: "xs",
        "data-test-subj": "artifacts-no-assignable-items",
        body: /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 158,
            columnNumber: 19
          }
        }, labels.flyoutNoArtifactsToBeAssignedMessage),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 11
        }
      });
    }

    // there are no results for the current search
    if ((artifacts === null || artifacts === void 0 ? void 0 : artifacts.total) === 0) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        titleSize: "xs",
        "data-test-subj": "artifacts-no-items-found",
        body: /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 169,
            columnNumber: 19
          }
        }, labels.flyoutNoSearchResultsMessage),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 166,
          columnNumber: 11
        }
      });
    }
  }, [isGlobalLoading, assignableArtifacts, artifacts === null || artifacts === void 0 ? void 0 : artifacts.total, labels.flyoutNoArtifactsToBeAssignedMessage, labels.flyoutNoSearchResultsMessage]);
  const artifactsAssignFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'artifactsAssignFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "artifacts-assign-flyout",
    "aria-labelledby": artifactsAssignFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: artifactsAssignFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }, labels.flyoutTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }), labels.flyoutSubtitle(policyItem.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }, ((artifacts === null || artifacts === void 0 ? void 0 : artifacts.total) || 0) > MAX_ALLOWED_RESULTS ? searchWarningMessage : null, !isLoadingAllNotAssigned && assignableArtifacts && /*#__PURE__*/_react.default.createElement(_search_exceptions.SearchExceptions, {
    onSearch: handleOnSearch,
    placeholder: labels.flyoutSearchPlaceholder,
    hideRefreshButton: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_assignable.PolicyArtifactsAssignableList, {
    "data-test-subj": "artifacts-assignable-list",
    artifacts: artifacts,
    selectedArtifactIds: selectedArtifactIds,
    isListLoading: isLoadingArtifacts || isRefetchingArtifacts,
    selectedArtifactsUpdated: handleSelectArtifacts,
    CardDecorator: CardDecorator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }), noItemsMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "artifacts-assign-cancel-button",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 15
    }
  }, labels.flyoutCancelButtonTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: "eui-textTruncate",
    css: {
      maxWidth: '300px'
    },
    "data-test-subj": "artifacts-assign-confirm-button",
    fill: true,
    onClick: handleOnConfirmAction,
    isLoading: bulkUpdateMutation.isLoading || isLoadingArtifacts || isRefetchingArtifacts,
    disabled: (0, _fp.isEmpty)(selectedArtifactIds),
    title: policyItem.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 15
    }
  }, labels.flyoutSubmitButtonTitle(policyItem.name))))));
});
PolicyArtifactsFlyout.displayName = 'PolicyArtifactsFlyout';