"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventFiltersFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _rxjs = require("rxjs");
var _use_with_artifact_submit_data = require("../../../../components/artifact_list_page/hooks/use_with_artifact_submit_data");
var _artifact_confirm_modal = require("../../../../components/artifact_list_page/components/artifact_confirm_modal");
var _form = require("./form");
var _utils = require("../utils");
var _kibana = require("../../../../../common/lib/kibana");
var _api_client = require("../../service/api_client");
var _translations = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/event_filters/view/components/event_filters_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EventFiltersFlyout = exports.EventFiltersFlyout = /*#__PURE__*/(0, _react.memo)(({
  onCancel: onClose,
  data,
  ...flyoutProps
}) => {
  const toasts = (0, _kibana.useToasts)();
  const http = (0, _kibana.useHttp)();
  const {
    isLoading: isSubmittingData,
    mutateAsync: submitData
  } = (0, _use_with_artifact_submit_data.useWithArtifactSubmitData)(_api_client.EventFiltersApiClient.getInstance(http), 'create');
  const [enrichedData, setEnrichedData] = (0, _react.useState)();
  const [isFormValid, setIsFormValid] = (0, _react.useState)(false);
  const {
    data: {
      search
    }
  } = (0, _kibana.useKibana)().services;
  const [exception, setException] = (0, _react.useState)((0, _utils.getInitialExceptionFromEvent)(data));
  const [confirmModalLabels, setConfirmModalLabels] = (0, _react.useState)();
  const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const enrichEvent = async () => {
      var _data$host;
      if (!data || !data._index) return;
      const searchResponse = await (0, _rxjs.lastValueFrom)(search.search({
        params: {
          index: data._index,
          body: {
            query: {
              match: {
                _id: data._id
              }
            }
          }
        }
      }));
      const enriched = {
        ...data,
        host: {
          ...data.host,
          os: {
            ...((data === null || data === void 0 ? void 0 : (_data$host = data.host) === null || _data$host === void 0 ? void 0 : _data$host.os) || {}),
            name: [searchResponse.rawResponse.hits.hits[0]._source.host.os.type]
          }
        }
      };
      setEnrichedData(enriched);

      // Update the exception with the correct OS from enriched data
      setException(prevException => ({
        ...prevException,
        os_types: (0, _utils.osTypeBasedOnAgentType)(enriched)
      }));
    };
    if (data) {
      enrichEvent();
    }
    return () => {
      setException((0, _utils.getInitialExceptionFromEvent)());
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const handleOnClose = (0, _react.useCallback)(() => {
    if (isSubmittingData) return;
    onClose();
  }, [isSubmittingData, onClose]);
  const submitEventFilter = (0, _react.useCallback)(() => {
    return submitData(exception, {
      onSuccess: result => {
        toasts.addSuccess((0, _translations.getCreationSuccessMessage)(result));
        onClose();
      },
      onError: error => {
        toasts.addError(error, (0, _translations.getCreationErrorMessage)(error));
      }
    });
  }, [exception, onClose, submitData, toasts]);
  const handleOnSubmit = (0, _react.useCallback)(() => {
    if (confirmModalLabels) {
      setShowConfirmModal(true);
    } else {
      return submitEventFilter();
    }
  }, [confirmModalLabels, submitEventFilter]);
  const confirmButtonMemo = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "add-exception-confirm-button",
    fill: true,
    disabled: !isFormValid || isSubmittingData || !!data && !enrichedData,
    onClick: handleOnSubmit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 9
    }
  }, data ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.eventFiltersFlyout.actions.confirm.update.withData",
    defaultMessage: "Add endpoint event filter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.eventFiltersFlyout.actions.confirm.create",
    defaultMessage: "Add event filter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  })), [data, enrichedData, handleOnSubmit, isFormValid, isSubmittingData]);

  // update flyout state with form state
  const onChange = (0, _react.useCallback)(formState => {
    if (!formState) return;
    setIsFormValid(formState.isValid);
    setException(formState.item);
    setConfirmModalLabels(formState.confirmModalLabels);
  }, []);
  const eventFiltersCreateFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'eventFiltersCreateFlyoutTitle'
  });
  const confirmModal = (0, _react.useMemo)(() => {
    if (confirmModalLabels) {
      const {
        title,
        body,
        confirmButton,
        cancelButton
      } = confirmModalLabels;
      return /*#__PURE__*/_react.default.createElement(_artifact_confirm_modal.ArtifactConfirmModal, {
        title: title,
        body: body,
        confirmButton: confirmButton,
        cancelButton: cancelButton,
        onSuccess: submitEventFilter,
        onCancel: () => setShowConfirmModal(false),
        "data-test-subj": "artifactConfirmModal",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 11
        }
      });
    }
  }, [confirmModalLabels, submitEventFilter]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, (0, _extends2.default)({
    size: "l",
    onClose: handleOnClose,
    "data-test-subj": "eventFiltersCreateFlyout",
    "aria-labelledby": eventFiltersCreateFlyoutTitleId
  }, flyoutProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: eventFiltersCreateFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 13
    }
  }, data ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.eventFiltersFlyout.title.create.withData",
    defaultMessage: "Add endpoint event filter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.eventFiltersFlyout.subtitle.create",
    defaultMessage: "Add event filter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 17
    }
  }))), data ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.eventFiltersFlyout.subtitle.create.withData",
    defaultMessage: "Endpoint security",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_form.EventFiltersForm, {
    allowSelectOs: true,
    error: undefined,
    disabled: false,
    item: exception,
    mode: "create",
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isDisabled: isSubmittingData,
    "data-test-subj": "cancelExceptionAddButton",
    onClick: handleOnClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.eventFilters.eventFiltersFlyout.actions.cancel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 13
    }
  }, confirmButtonMemo))), showConfirmModal && confirmModal);
});
EventFiltersFlyout.displayName = 'EventFiltersFlyout';