"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetEndpointActionList = void 0;
var _reactQuery = require("@kbn/react-query");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetEndpointActionList = (query, options = {}) => {
  const http = (0, _kibana.useHttp)();

  // prepend and append * to userIds for fuzzy search
  let userIds = query.userIds;
  if (typeof query.userIds === 'string') {
    userIds = `*${query.userIds}*`;
  } else if (Array.isArray(query.userIds)) {
    userIds = query.userIds.map(userId => `*${userId}*`);
  }
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-action-list', query],
    ...options,
    keepPreviousData: true,
    queryFn: async () => {
      return http.get(_constants.BASE_ENDPOINT_ACTION_ROUTE, {
        version: '2023-10-31',
        query: {
          agentIds: query.agentIds,
          agentTypes: query.agentTypes,
          commands: query.commands,
          endDate: query.endDate,
          page: query.page,
          pageSize: query.pageSize,
          startDate: query.startDate,
          statuses: query.statuses,
          userIds,
          withOutputs: query.withOutputs,
          types: query.types
        }
      }).catch(error => {
        // if the error is a 404 or index not found exception, return an empty response
        // this is to handle the case where the endpoint action index does not exist yet
        // and avoid showing an error to the user in that case
        if (error.body.statusCode === 404 || error.body.message.includes('index_not_found_exception')) {
          return {
            page: 1,
            pageSize: query.pageSize || 10,
            total: 0,
            data: [] // empty list of pending actions
          };
        }
        return error;
      });
    }
  });
};
exports.useGetEndpointActionList = useGetEndpointActionList;