"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogExpandedTray = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _runscript_action_result = require("../../runscript_action_result");
var _running_processes_action_results = require("../../running_processes_action_results");
var _translations = require("../../../../common/translations");
var _constants = require("../../../../../common/endpoint/service/response_actions/constants");
var _type_guards = require("../../../../../common/endpoint/service/response_actions/type_guards");
var _endpoint_upload_action_result = require("../../endpoint_upload_action_result");
var _user_privileges = require("../../../../common/components/user_privileges");
var _translations2 = require("../translations");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _response_action_file_download_link = require("../../response_action_file_download_link");
var _endpoint_action_failure_message = require("../../endpoint_action_failure_message");
var _endpoint_execute_action = require("../../endpoint_execute_action");
var _empty_value = require("../../../../common/components/empty_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_response_actions_list/components/action_log_expanded_tray.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyValue = (0, _empty_value.getEmptyValue)();
const customDescriptionListCss = (0, _common.css)`
  &.euiDescriptionList {
    > .euiDescriptionList__title {
      color: ${props => props.theme.eui.euiColorDarkShade};
      font-size: ${props => props.theme.eui.euiFontSizeXS};
    }

    > .euiDescriptionList__title,
    > .euiDescriptionList__description {
      font-weight: ${props => props.theme.eui.euiFontWeightRegular};
    }
  }
`;
const topSpacingCss = (0, _common.css)`
  ${props => `${props.theme.eui.euiSize} 0`}
`;
const dashedBorderCss = (0, _common.css)`
  ${props => `1px dashed ${props.theme.eui.euiColorDisabled}`};
`;
const StyledDescriptionListOutput = (0, _common.euiStyled)(_eui.EuiDescriptionList).attrs({
  compressed: true
})`
  ${customDescriptionListCss}
  dd {
    margin: ${topSpacingCss};
    padding: ${topSpacingCss};
    border-top: ${dashedBorderCss};
    border-bottom: ${dashedBorderCss};
  }
`;
const StyledDescriptionList = (0, _common.euiStyled)(_eui.EuiDescriptionList).attrs({
  compressed: true,
  type: 'column'
})`
  ${customDescriptionListCss}
`;
const StyledEuiCodeBlock = (0, _common.euiStyled)(_eui.EuiCodeBlock).attrs({
  transparentBackground: true,
  paddingSize: 'none'
})`
  code {
    color: ${props => props.theme.eui.euiColorDarkShade} !important;
  }
`;
const StyledEuiFlexGroup = (0, _common.euiStyled)(_eui.EuiFlexGroup).attrs({
  direction: 'column',
  className: 'eui-yScrollWithShadows',
  gutterSize: 's'
})`
  max-height: 40vh;
  min-height: 270px;
  overflow-y: auto;
`;
const OutputContent = /*#__PURE__*/(0, _react.memo)(({
  action,
  fromAlertWorkaround = false,
  'data-test-subj': dataTestSubj
}) => {
  var _action$errors;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    canWriteFileOperations,
    canReadActionsLogManagement,
    canAccessEndpointActionsLogManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    command: _command,
    isCompleted,
    isExpired,
    wasSuccessful
  } = action;
  const command = _constants.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP[_command];

  // FIXME:PT remove once automated response actions are corrected to use `ActionDetails` (team issue 9822)
  if (fromAlertWorkaround && (_action$errors = action.errors) !== null && _action$errors !== void 0 && _action$errors.length) {
    var _action$errors2;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ((_action$errors2 = action.errors) !== null && _action$errors2 !== void 0 ? _action$errors2 : [_i18n.i18n.translate('xpack.securitySolution.actionLogExpandedTray.missingErrors', {
      defaultMessage: 'Action did not specify any errors'
    })]).map(error => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }, error)));
  }
  if (isExpired) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations2.OUTPUT_MESSAGES.hasExpired(command));
  }
  if (!isCompleted) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations2.OUTPUT_MESSAGES.isPending(command));
  }
  if (!wasSuccessful) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations2.OUTPUT_MESSAGES.hasFailed(command), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_endpoint_action_failure_message.EndpointActionFailureMessage, {
      action: action,
      "data-test-subj": getTestId('failureMessage'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 9
      }
    }));
  }
  if ((0, _type_guards.isGetFileAction)(action)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations2.OUTPUT_MESSAGES.wasSuccessful(command), /*#__PURE__*/_react.default.createElement(_response_action_file_download_link.ResponseActionFileDownloadLink, {
      action: action,
      canAccessFileDownloadLink: canWriteFileOperations,
      textSize: "xs",
      "data-test-subj": getTestId('getFileDownloadLink'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }));
  }
  if ((0, _type_guards.isExecuteAction)(action)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      "data-test-subj": getTestId('executeDetails'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 7
      }
    }, action.agents.map(agentId => /*#__PURE__*/_react.default.createElement("div", {
      key: agentId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 11
      }
    }, _translations2.OUTPUT_MESSAGES.wasSuccessful(command), /*#__PURE__*/_react.default.createElement(_endpoint_execute_action.ExecuteActionHostResponse, {
      action: action,
      agentId: agentId,
      canAccessFileDownloadLink: canAccessEndpointActionsLogManagement || canReadActionsLogManagement,
      textSize: "xs",
      "data-test-subj": getTestId('actionsLogTray'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 13
      }
    }))));
  }
  if ((0, _type_guards.isUploadAction)(action)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      "data-test-subj": getTestId('uploadDetails'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 9
      }
    }, _translations2.OUTPUT_MESSAGES.wasSuccessful(command)), /*#__PURE__*/_react.default.createElement(_endpoint_upload_action_result.EndpointUploadActionResult, {
      action: action,
      "data-test-subj": getTestId('uploadOutput'),
      textSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 9
      }
    }));
  }
  if ((0, _type_guards.isProcessesAction)(action)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      "data-test-subj": getTestId('processesDetails'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 202,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 9
      }
    }, _translations2.OUTPUT_MESSAGES.wasSuccessful(command)), /*#__PURE__*/_react.default.createElement(_running_processes_action_results.RunningProcessesActionResults, {
      action: action,
      "data-test-subj": "processesOutput",
      textSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 9
      }
    }));
  }
  if ((0, _type_guards.isRunScriptAction)(action)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      "data-test-subj": getTestId('runScriptDetails'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 7
      }
    }, action.agents.map(agentId => /*#__PURE__*/_react.default.createElement("div", {
      key: agentId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 11
      }
    }, _translations2.OUTPUT_MESSAGES.wasSuccessful(command), action.agentType === 'sentinel_one' ? /*#__PURE__*/_react.default.createElement(_runscript_action_result.RunscriptActionResult, {
      action: action,
      agentId: agentId,
      textSize: "xs",
      "data-test-subj": getTestId('actionsLogTray'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_endpoint_execute_action.ExecuteActionHostResponse, {
      action: action,
      agentId: agentId,
      canAccessFileDownloadLink: canAccessEndpointActionsLogManagement || canReadActionsLogManagement,
      textSize: "xs",
      "data-test-subj": getTestId('actionsLogTray'),
      hideFile: action.agentType === 'crowdstrike',
      hideContext: true,
      showPasscode: action.agentType !== 'microsoft_defender_endpoint',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 15
      }
    }))));
  }

  // CrowdStrike Isolate/Release actions
  if (action.agentType === 'crowdstrike') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations2.OUTPUT_MESSAGES.submittedSuccessfully(command));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations2.OUTPUT_MESSAGES.wasSuccessful(command));
});
OutputContent.displayName = 'OutputContent';
const ActionsLogExpandedTray = exports.ActionsLogExpandedTray = /*#__PURE__*/(0, _react.memo)(({
  action,
  fromAlertWorkaround = false,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    hosts,
    startedAt,
    completedAt,
    command: _command,
    comment,
    parameters,
    agentType
  } = action;
  const parametersList = (0, _react.useMemo)(() => parameters ? Object.entries(parameters).map(([key, value]) => {
    return `${key}: ${value}`;
  }) : undefined, [parameters]);
  const command = _constants.RESPONSE_ACTION_API_COMMAND_TO_CONSOLE_COMMAND_MAP[_command];
  const dataList = (0, _react.useMemo)(() => {
    const list = [{
      title: _translations2.OUTPUT_MESSAGES.expandSection.placedAt,
      description: `${startedAt}`
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.startedAt,
      description: `${startedAt}`
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.completedAt,
      description: `${completedAt !== null && completedAt !== void 0 ? completedAt : emptyValue}`
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.input,
      description: `${command}`
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.parameters,
      description: parametersList ? parametersList.join(', ') : emptyValue
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.comment,
      description: comment ? comment : emptyValue
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.hostname,
      description: (0, _lodash.reduce)(hosts, (acc, host, agentId) => {
        if (host.name.trim().length) {
          acc.push(host.name);
        } else {
          acc.push(agentId);
        }
        return acc;
      }, []).join(', ') || emptyValue
    }, {
      title: _translations2.OUTPUT_MESSAGES.expandSection.agentType,
      description: (0, _translations.getAgentTypeName)(agentType) || emptyValue
    }];
    return list.map(({
      title,
      description
    }) => {
      return {
        title: /*#__PURE__*/_react.default.createElement(StyledEuiCodeBlock, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 338,
            columnNumber: 16
          }
        }, title),
        description: /*#__PURE__*/_react.default.createElement(StyledEuiCodeBlock, {
          "data-test-subj": getTestId(`action-details-info-${title}`),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 340,
            columnNumber: 11
          }
        }, description)
      };
    });
  }, [agentType, command, comment, completedAt, getTestId, hosts, parametersList, startedAt]);
  const outputList = (0, _react.useMemo)(() => [{
    title: /*#__PURE__*/_react.default.createElement(StyledEuiCodeBlock, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 352,
        columnNumber: 11
      }
    }, `${_translations2.OUTPUT_MESSAGES.expandSection.output}:`),
    description:
    /*#__PURE__*/
    // codeblock for output
    _react.default.createElement(StyledEuiCodeBlock, {
      "data-test-subj": getTestId('details-tray-output'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 356,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(OutputContent, {
      action: action,
      "data-test-subj": dataTestSubj,
      fromAlertWorkaround: fromAlertWorkaround,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 357,
        columnNumber: 13
      }
    }))
  }], [action, dataTestSubj, fromAlertWorkaround, getTestId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    "data-test-subj": getTestId('details-tray'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StyledDescriptionList, {
    listItems: dataList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StyledDescriptionListOutput, {
    listItems: outputList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 11
    }
  }))));
});
ActionsLogExpandedTray.displayName = 'ActionsLogExpandedTray';