"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EffectScope = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _user_privileges = require("../../../../common/components/user_privileges");
var _translations = require("./translations");
var _text_value_display = require("./text_value_display");
var _context_menu_with_router_support = require("../../context_menu_with_router_support");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/artifact_entry_card/components/effect_scope.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// FIXME:PT support being able to show per policy label for Artifacst that have >0 policies, but no menu
//          the intent in this component was to also support to be able to display only text for artifacts
//          by policy (>0), but **NOT** show the menu.
//          So something like: `<EffectScope perPolicyCount={3} />`
//          This should display it as "Applied to 3 policies", but NOT as a menu with links

const POLICY_DETAILS_NOT_ACCESSIBLE = _i18n.i18n.translate('xpack.securitySolution.effectScope.policyDetailsNotAccessible', {
  defaultMessage: 'Policy is no longer accessible'
});
const POLICY_DETAILS_NOT_ACCESSIBLE_IN_ACTIVE_SPACE = _i18n.i18n.translate('xpack.securitySolution.effectScope.policyDetailsNotAccessibleInActiveSpace', {
  defaultMessage: 'Policy is not accessible from the current space'
});
const StyledWithContextMenuShiftedWrapper = (0, _styledComponents.default)('div')`
  margin-left: -10px;
`;
const StyledEuiButtonEmpty = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  height: 10px !important;
`;
const EffectScope = exports.EffectScope = /*#__PURE__*/(0, _react.memo)(({
  policies,
  loadingPoliciesList = false,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const [icon, label] = (0, _react.useMemo)(() => {
    return policies ? ['partial', (0, _translations.POLICY_EFFECT_SCOPE)(policies.length)] : ['globe', _translations.GLOBAL_EFFECT_SCOPE];
  }, [policies]);
  const effectiveScopeLabel = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: "center",
    gutterSize: "s",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": getTestId('value'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_text_value_display.TextValueDisplay, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, label)));
  return policies && policies.length ? /*#__PURE__*/_react.default.createElement(StyledWithContextMenuShiftedWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(WithContextMenu, {
    policies: policies,
    loadingPoliciesList: loadingPoliciesList,
    canReadPolicies: canReadPolicyManagement,
    "data-test-subj": getTestId('popupMenu'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, effectiveScopeLabel)) : effectiveScopeLabel;
});
EffectScope.displayName = 'EffectScope';
const WithContextMenu = /*#__PURE__*/(0, _react.memo)(({
  policies,
  loadingPoliciesList = false,
  canReadPolicies,
  children,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isSpacesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointManagementSpaceAwarenessEnabled');
  const menuItems = (0, _react.useMemo)(() => {
    return policies.map(policyMenuItem => {
      const hasHref = Boolean(policyMenuItem.href);
      return {
        ...policyMenuItem,
        hoverInfo: hasHref && canReadPolicies ? /*#__PURE__*/_react.default.createElement(StyledEuiButtonEmpty, {
          flush: "right",
          size: "s",
          iconSide: "right",
          iconType: "popout",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 131,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.contextMenuItemByRouter.viewDetails",
          defaultMessage: "View details",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 17
          }
        })) : undefined,
        disabled: !hasHref,
        toolTipContent: !hasHref ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSpacesEnabled ? POLICY_DETAILS_NOT_ACCESSIBLE_IN_ACTIVE_SPACE : POLICY_DETAILS_NOT_ACCESSIBLE) : undefined
      };
    });
  }, [canReadPolicies, isSpacesEnabled, policies]);
  return /*#__PURE__*/_react.default.createElement(_context_menu_with_router_support.ContextMenuWithRouterSupport, {
    maxHeight: "235px",
    fixedWidth: true,
    panelPaddingSize: "none",
    items: menuItems,
    anchorPosition: policies.length > 1 ? 'rightCenter' : 'rightUp',
    "data-test-subj": dataTestSubj,
    loading: loadingPoliciesList,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      "data-test-subj": getTestId('button'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    }, children),
    title: (0, _translations.POLICY_EFFECT_SCOPE_TITLE)(policies.length),
    isNavigationDisabled: !canReadPolicies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  });
});
WithContextMenu.displayName = 'WithContextMenu';