"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardActionsFlexItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../common/translations");
var _user_privileges = require("../../../../common/components/user_privileges");
var _translations2 = require("./translations");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _artifacts = require("../../../../../common/endpoint/service/artifacts");
var _card_artifact_context = require("./card_artifact_context");
var _actions_context_menu = require("../../actions_context_menu");
var _utils = require("../../../../../common/endpoint/service/artifacts/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/artifact_entry_card/components/card_actions_flex_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CardActionsFlexItem = exports.CardActionsFlexItem = /*#__PURE__*/(0, _react.memo)(({
  actions,
  'data-test-subj': dataTestSubj
}) => {
  const item = (0, _card_artifact_context.useCardArtifact)();
  const canManageGlobalArtifacts = (0, _user_privileges.useUserPrivileges)().endpointPrivileges.canManageGlobalArtifacts;
  const isGlobal = (0, _react.useMemo)(() => (0, _artifacts.isArtifactGlobal)(item), [item]);
  const ownerSpaceIds = (0, _react.useMemo)(() => (0, _utils.getArtifactOwnerSpaceIds)(item), [item]);
  const isSpacesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointManagementSpaceAwarenessEnabled');
  const activeSpaceId = (0, _use_space_id.useSpaceId)();
  const {
    isDisabled,
    disabledTooltip
  } = (0, _react.useMemo)(() => {
    if (!isSpacesEnabled || canManageGlobalArtifacts) {
      return {
        isDisabled: false,
        disabledTooltip: undefined
      };
    }
    if (isGlobal) {
      return {
        isDisabled: true,
        disabledTooltip: _translations.NO_PRIVILEGE_FOR_MANAGEMENT_OF_GLOBAL_ARTIFACT_MESSAGE
      };
    }
    if (!activeSpaceId || !ownerSpaceIds.includes(activeSpaceId)) {
      return {
        isDisabled: true,
        disabledTooltip: _translations2.MANAGEMENT_OF_SHARED_PER_POLICY_ARTIFACT_NOT_ALLOWED_MESSAGE
      };
    }
    return {
      isDisabled: false,
      disabledTooltip: undefined
    };
  }, [activeSpaceId, canManageGlobalArtifacts, isGlobal, isSpacesEnabled, ownerSpaceIds]);
  return actions && actions.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_actions_context_menu.ActionsContextMenu, {
    items: actions,
    icon: "boxesHorizontal",
    isDisabled: isDisabled,
    disabledTooltip: disabledTooltip,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  })) : null;
});
CardActionsFlexItem.displayName = 'CardActionsFlexItem';