"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18nReact = require("@kbn/i18n-react");
var _expandable_section = require("../../document_details/right/components/expandable_section");
var _rule_about_section = require("../../../detection_engine/rule_management/components/rule_details/rule_about_section");
var _rule_schedule_section = require("../../../detection_engine/rule_management/components/rule_details/rule_schedule_section");
var _rule_definition_section = require("../../../detection_engine/rule_management/components/rule_details/rule_definition_section");
var _step_rule_actions = require("../../../detection_engine/rule_creation/components/step_rule_actions");
var _helpers = require("../../../detection_engine/common/helpers");
var _test_ids = require("./test_ids");
var _flyout_body = require("../../shared/components/flyout_body");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/rule_details/right/content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const panelViewStyle = (0, _css.css)`
  dt {
    font-size: 90% !important;
  }

  text-overflow: ellipsis;

  .euiFlexGroup {
    flex-wrap: inherit;
  }

  .euiFlexItem {
    inline-size: inherit;
    flex-basis: inherit;
  }
`;
/**
 * Rule details content on the right section of expandable flyout
 */
const PanelContent = exports.PanelContent = /*#__PURE__*/(0, _react.memo)(({
  rule
}) => {
  const {
    ruleActionsData
  } = (0, _react.useMemo)(() => rule != null ? (0, _helpers.getStepsData)({
    rule,
    detailsView: true
  }) : {
    ruleActionsData: null
  }, [rule]);
  const hasNotificationActions = (0, _react.useMemo)(() => {
    var _ruleActionsData$acti;
    return Boolean(ruleActionsData === null || ruleActionsData === void 0 ? void 0 : (_ruleActionsData$acti = ruleActionsData.actions) === null || _ruleActionsData$acti === void 0 ? void 0 : _ruleActionsData$acti.length);
  }, [ruleActionsData]);
  const hasResponseActions = (0, _react.useMemo)(() => {
    var _ruleActionsData$resp;
    return Boolean(ruleActionsData === null || ruleActionsData === void 0 ? void 0 : (_ruleActionsData$resp = ruleActionsData.responseActions) === null || _ruleActionsData$resp === void 0 ? void 0 : _ruleActionsData$resp.length);
  }, [ruleActionsData]);
  const hasActions = (0, _react.useMemo)(() => ruleActionsData != null && (hasNotificationActions || hasResponseActions), [ruleActionsData, hasNotificationActions, hasResponseActions]);
  return /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    "data-test-subj": _test_ids.BODY_TEST_ID,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.preview.rule.aboutLabel",
      defaultMessage: "About",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    }),
    expanded: true,
    "data-test-subj": _test_ids.ABOUT_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, rule.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_rule_about_section.RuleAboutSection, {
    rule: rule,
    hideName: true,
    hideDescription: true,
    type: "row",
    rowGutterSize: "s",
    className: panelViewStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.preview.rule.definitionLabel",
      defaultMessage: "Definition",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 13
      }
    }),
    expanded: false,
    "data-test-subj": _test_ids.DEFINITION_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_definition_section.RuleDefinitionSection, {
    rule: rule,
    type: "row",
    rowGutterSize: "s",
    className: panelViewStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.preview.rule.scheduleLabel",
      defaultMessage: "Schedule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 13
      }
    }),
    expanded: false,
    "data-test-subj": _test_ids.SCHEDULE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_schedule_section.RuleScheduleSection, {
    rule: rule,
    type: "row",
    rowGutterSize: "s",
    className: panelViewStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }), hasActions && ruleActionsData != null && /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.preview.rule.actionsLabel",
      defaultMessage: "Actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 15
      }
    }),
    expanded: false,
    "data-test-subj": _test_ids.ACTIONS_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_step_rule_actions.StepRuleActionsReadOnly, {
    addPadding: false,
    defaultValues: ruleActionsData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 13
    }
  }))));
});
PanelContent.displayName = 'PanelContent';