"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServicePanel = exports.SERVICE_PANEL_RISK_SCORE_QUERY_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _fp = require("lodash/fp");
var _search_strategy = require("../../../../common/search_strategy");
var _use_refetch_query_by_id = require("../../../entity_analytics/api/hooks/use_refetch_query_by_id");
var _risk_inputs_tab = require("../../../entity_analytics/components/entity_details_flyout/tabs/risk_inputs/risk_inputs_tab");
var _use_calculate_entity_risk_score = require("../../../entity_analytics/api/hooks/use_calculate_entity_risk_score");
var _use_risk_score = require("../../../entity_analytics/api/hooks/use_risk_score");
var _manage_query = require("../../../common/components/page/manage_query");
var _use_global_time = require("../../../common/containers/use_global_time");
var _flyout_loading = require("../../shared/components/flyout_loading");
var _flyout_navigation = require("../../shared/components/flyout_navigation");
var _content = require("./content");
var _header = require("./header");
var _use_observed_service = require("./hooks/use_observed_service");
var _types = require("../../../../common/entity_analytics/types");
var _left_panel_header = require("../shared/components/left_panel/left_panel_header");
var _use_navigate_to_service_details = require("./hooks/use_navigate_to_service_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/service_right/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SERVICE_PANEL_RISK_SCORE_QUERY_ID = exports.SERVICE_PANEL_RISK_SCORE_QUERY_ID = 'servicePanelRiskScoreQuery';
const FIRST_RECORD_PAGINATION = {
  cursorStart: 0,
  querySize: 1
};
const ServicePanel = ({
  contextID,
  scopeId,
  serviceName
}) => {
  var _useRefetchQueryById;
  const serviceNameFilterQuery = (0, _react.useMemo)(() => serviceName ? (0, _search_strategy.buildEntityNameFilter)(_types.EntityType.service, [serviceName]) : undefined, [serviceName]);
  const riskScoreState = (0, _use_risk_score.useRiskScore)({
    riskEntity: _types.EntityType.service,
    filterQuery: serviceNameFilterQuery,
    onlyLatest: false,
    pagination: FIRST_RECORD_PAGINATION
  });
  const {
    inspect,
    refetch,
    loading
  } = riskScoreState;
  const {
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  const observedService = (0, _use_observed_service.useObservedService)(serviceName, scopeId);
  const {
    data: serviceRisk
  } = riskScoreState;
  const serviceRiskData = serviceRisk && serviceRisk.length > 0 ? serviceRisk[0] : undefined;
  const isRiskScoreExist = !!(serviceRiskData !== null && serviceRiskData !== void 0 && serviceRiskData.service.risk);
  const refetchRiskInputsTab = (_useRefetchQueryById = (0, _use_refetch_query_by_id.useRefetchQueryById)(_risk_inputs_tab.RISK_INPUTS_TAB_QUERY_ID)) !== null && _useRefetchQueryById !== void 0 ? _useRefetchQueryById : _fp.noop;
  const refetchRiskScore = (0, _react.useCallback)(() => {
    refetch();
    refetchRiskInputsTab();
  }, [refetch, refetchRiskInputsTab]);
  const {
    isLoading: recalculatingScore,
    calculateEntityRiskScore
  } = (0, _use_calculate_entity_risk_score.useCalculateEntityRiskScore)(_types.EntityType.service, serviceName, {
    onSuccess: refetchRiskScore
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect,
    loading,
    queryId: SERVICE_PANEL_RISK_SCORE_QUERY_ID,
    refetch,
    setQuery
  });
  const {
    openDetailsPanel,
    isLinkEnabled
  } = (0, _use_navigate_to_service_details.useNavigateToServiceDetails)({
    serviceName,
    scopeId,
    contextID,
    isRiskScoreExist
  });
  const openPanelFirstTab = (0, _react.useCallback)(() => openDetailsPanel({
    tab: _left_panel_header.EntityDetailsLeftPanelTab.RISK_INPUTS
  }), [openDetailsPanel]);
  if (observedService.isLoading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
    flyoutIsExpandable: isRiskScoreExist,
    expandDetails: openPanelFirstTab,
    isRulePreview: scopeId === _securitysolutionDataTable.TableId.rulePreview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_header.ServicePanelHeader, {
    serviceName: serviceName,
    observedService: observedService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_content.ServicePanelContent, {
    serviceName: serviceName,
    observedService: observedService,
    riskScoreState: riskScoreState,
    recalculatingScore: recalculatingScore,
    onAssetCriticalityChange: calculateEntityRiskScore,
    contextID: contextID,
    scopeId: scopeId,
    openDetailsPanel: openDetailsPanel,
    isLinkEnabled: isLinkEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }));
};
exports.ServicePanel = ServicePanel;
ServicePanel.displayName = 'ServicePanel';