"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CorrelationsOverview = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _reactRedux = require("react-redux");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _use_show_related_alerts_by_session = require("../../shared/hooks/use_show_related_alerts_by_session");
var _related_alerts_by_session = require("./related_alerts_by_session");
var _use_show_related_alerts_by_same_source_event = require("../../shared/hooks/use_show_related_alerts_by_same_source_event");
var _related_alerts_by_same_source_event = require("./related_alerts_by_same_source_event");
var _related_alerts_by_ancestry = require("./related_alerts_by_ancestry");
var _use_show_related_alerts_by_ancestry = require("../../shared/hooks/use_show_related_alerts_by_ancestry");
var _suppressed_alerts = require("./suppressed_alerts");
var _use_show_suppressed_alerts = require("../../shared/hooks/use_show_suppressed_alerts");
var _related_cases = require("./related_cases");
var _use_show_related_cases = require("../../shared/hooks/use_show_related_cases");
var _test_ids = require("./test_ids");
var _context = require("../../shared/context");
var _left = require("../../left");
var _correlations_details = require("../../left/components/correlations_details");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_security_default_patterns = require("../../../../data_view_manager/hooks/use_security_default_patterns");
var _store = require("../../../../sourcerer/store");
var _use_navigate_to_left_panel = require("../../shared/hooks/use_navigate_to_left_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/correlations_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Correlations section under Insights section, overview tab.
 * The component fetches the necessary data, then pass it down to the InsightsSubSection component for loading and error state,
 * and the SummaryPanel component for data rendering.
 */
const CorrelationsOverview = () => {
  var _useSelector$patternL, _useSelector, _get;
  const {
    dataAsNestedObject,
    eventId,
    getFieldsData,
    scopeId,
    isRulePreview,
    isPreviewMode
  } = (0, _context.useDocumentDetailsContext)();
  const {
    newDataViewPickerEnabled
  } = (0, _use_experimental_features.useEnableExperimental)();
  const oldSecurityDefaultPatterns = (_useSelector$patternL = (_useSelector = (0, _reactRedux.useSelector)(_store.sourcererSelectors.defaultDataView)) === null || _useSelector === void 0 ? void 0 : _useSelector.patternList) !== null && _useSelector$patternL !== void 0 ? _useSelector$patternL : [];
  const {
    indexPatterns: experimentalSecurityDefaultIndexPatterns
  } = (0, _use_security_default_patterns.useSecurityDefaultPatterns)();
  const securityDefaultPatterns = newDataViewPickerEnabled ? experimentalSecurityDefaultIndexPatterns : oldSecurityDefaultPatterns;
  const {
    navigateToLeftPanel: goToCorrelationsTab,
    isEnabled: isLinkEnabled
  } = (0, _use_navigate_to_left_panel.useNavigateToLeftPanel)({
    tab: _left.LeftPanelInsightsTab,
    subTab: _correlations_details.CORRELATIONS_TAB_ID
  });
  const {
    show: showAlertsByAncestry,
    documentId
  } = (0, _use_show_related_alerts_by_ancestry.useShowRelatedAlertsByAncestry)({
    getFieldsData,
    dataAsNestedObject,
    eventId,
    isRulePreview
  });
  const {
    show: showSameSourceAlerts,
    originalEventId
  } = (0, _use_show_related_alerts_by_same_source_event.useShowRelatedAlertsBySameSourceEvent)({
    eventId,
    getFieldsData
  });
  const {
    show: showAlertsBySession,
    entityId
  } = (0, _use_show_related_alerts_by_session.useShowRelatedAlertsBySession)({
    getFieldsData
  });
  const showCases = (0, _use_show_related_cases.useShowRelatedCases)({
    getFieldsData
  });
  const {
    show: showSuppressedAlerts,
    alertSuppressionCount
  } = (0, _use_show_suppressed_alerts.useShowSuppressedAlerts)({
    getFieldsData
  });
  const canShowAtLeastOneInsight = showAlertsByAncestry || showSameSourceAlerts || showAlertsBySession || showCases || showSuppressedAlerts;
  const ruleType = (_get = (0, _lodash.get)(dataAsNestedObject, _ruleDataUtils.ALERT_RULE_TYPE)) === null || _get === void 0 ? void 0 : _get[0];
  const link = (0, _react.useMemo)(() => isLinkEnabled ? {
    callback: goToCorrelationsTab,
    tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.correlations.overviewTooltip",
      defaultMessage: "Show all correlations",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 15
      }
    })
  } : undefined, [goToCorrelationsTab, isLinkEnabled]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.insights.correlations.overviewTitle",
        defaultMessage: "Correlations",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 11
        }
      }),
      link,
      iconType: !isPreviewMode ? 'arrowStart' : undefined
    },
    "data-test-subj": _test_ids.CORRELATIONS_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, canShowAtLeastOneInsight ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, showSuppressedAlerts && /*#__PURE__*/_react.default.createElement(_suppressed_alerts.SuppressedAlerts, {
    alertSuppressionCount: alertSuppressionCount,
    ruleType: ruleType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }), showCases && /*#__PURE__*/_react.default.createElement(_related_cases.RelatedCases, {
    eventId: eventId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 25
    }
  }), showSameSourceAlerts && /*#__PURE__*/_react.default.createElement(_related_alerts_by_same_source_event.RelatedAlertsBySameSourceEvent, {
    originalEventId: originalEventId,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }), showAlertsBySession && entityId && /*#__PURE__*/_react.default.createElement(_related_alerts_by_session.RelatedAlertsBySession, {
    entityId: entityId,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }), showAlertsByAncestry && /*#__PURE__*/_react.default.createElement(_related_alerts_by_ancestry.RelatedAlertsByAncestry, {
    documentId: documentId,
    indices: securityDefaultPatterns,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.correlations.noDataDescription",
    defaultMessage: "No correlations data available.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }));
};
exports.CorrelationsOverview = CorrelationsOverview;
CorrelationsOverview.displayName = 'CorrelationsOverview';