"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _panel_keys = require("../shared/constants/panel_keys");
var _use_tabs = require("../right/hooks/use_tabs");
var _use_flyout_is_expandable = require("../right/hooks/use_flyout_is_expandable");
var _context = require("../shared/context");
var _header = require("../right/header");
var _content = require("../right/content");
var _footer = require("./footer");
var _constants = require("./constants");
var _use_basic_data_from_details_data = require("../shared/hooks/use_basic_data_from_details_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/preview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Panel to be displayed in the document details expandable flyout on top of right section
 */
const PreviewPanel = exports.PreviewPanel = /*#__PURE__*/(0, _react.memo)(({
  path
}) => {
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    eventId,
    indexName,
    scopeId,
    getFieldsData,
    dataAsNestedObject,
    dataFormattedForFieldBrowser
  } = (0, _context.useDocumentDetailsContext)();
  const {
    isAlert
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const flyoutIsExpandable = (0, _use_flyout_is_expandable.useFlyoutIsExpandable)({
    getFieldsData,
    dataAsNestedObject
  });
  const {
    tabsDisplayed,
    selectedTabId
  } = (0, _use_tabs.useTabs)({
    flyoutIsExpandable,
    path
  });
  const setSelectedTabId = tabId => {
    openPreviewPanel({
      id: _panel_keys.DocumentDetailsPreviewPanelKey,
      path: {
        tab: tabId
      },
      params: {
        id: eventId,
        indexName,
        scopeId,
        isPreviewMode: true,
        banner: isAlert ? _constants.ALERT_PREVIEW_BANNER : _constants.EVENT_PREVIEW_BANNER
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.PanelHeader, {
    tabs: tabsDisplayed,
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId,
    css: {
      marginTop: '-15px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_content.PanelContent, {
    tabs: tabsDisplayed,
    selectedTabId: selectedTabId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_footer.PreviewPanelFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
});
PreviewPanel.displayName = 'PreviewPanel';