"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navTabsUsers = void 0;
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("./translations"));
var _model = require("../store/model");
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTabsOnUsersUrl = tabName => `${_constants.USERS_PATH}/${tabName}`;
const navTabsUsers = hasMlUserPermissions => {
  const hiddenTabs = [];
  const userNavTabs = {
    [_model.UsersTableType.events]: {
      id: _model.UsersTableType.events,
      name: i18n.NAVIGATION_EVENTS_TITLE,
      href: getTabsOnUsersUrl(_model.UsersTableType.events),
      disabled: false
    },
    [_model.UsersTableType.allUsers]: {
      id: _model.UsersTableType.allUsers,
      name: i18n.NAVIGATION_ALL_USERS_TITLE,
      href: getTabsOnUsersUrl(_model.UsersTableType.allUsers),
      disabled: false
    },
    [_model.UsersTableType.authentications]: {
      id: _model.UsersTableType.authentications,
      name: i18n.NAVIGATION_AUTHENTICATIONS_TITLE,
      href: getTabsOnUsersUrl(_model.UsersTableType.authentications),
      disabled: false
    },
    [_model.UsersTableType.anomalies]: {
      id: _model.UsersTableType.anomalies,
      name: i18n.NAVIGATION_ANOMALIES_TITLE,
      href: getTabsOnUsersUrl(_model.UsersTableType.anomalies),
      disabled: false
    },
    [_model.UsersTableType.risk]: {
      id: _model.UsersTableType.risk,
      name: i18n.NAVIGATION_RISK_TITLE,
      href: getTabsOnUsersUrl(_model.UsersTableType.risk),
      disabled: false
    }
  };
  if (!hasMlUserPermissions) {
    hiddenTabs.push(_model.UsersTableType.anomalies);
  }
  return (0, _fp.omit)(hiddenTabs, userNavTabs);
};
exports.navTabsUsers = navTabsUsers;