"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HttpQueryTabBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _network_http_table = require("../../components/network_http_table");
var _network_http = require("../../containers/network_http");
var _manage_query = require("../../../../common/components/page/manage_query");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/pages/navigation/http_query_tab_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NetworkHttpTableManage = (0, _manage_query.manageQuery)(_network_http_table.NetworkHttpTable);
const HttpQueryTabBody = ({
  endDate,
  filterQuery,
  indexNames,
  skip,
  startDate,
  setQuery,
  type
}) => {
  const queryId = `${_network_http.ID}-${type}`;
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(queryId);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const [loading, {
    id,
    inspect,
    isInspected,
    loadPage,
    networkHttp,
    pageInfo,
    refetch,
    totalCount
  }] = (0, _network_http.useNetworkHttp)({
    endDate,
    filterQuery,
    id: queryId,
    indexNames,
    skip: querySkip,
    startDate,
    type
  });
  return /*#__PURE__*/_react.default.createElement(NetworkHttpTableManage, {
    data: networkHttp,
    fakeTotalCount: (0, _fp.getOr)(50, 'fakeTotalCount', pageInfo),
    id: id,
    inspect: inspect,
    isInspect: isInspected,
    loading: loading,
    loadPage: loadPage,
    refetch: refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: (0, _fp.getOr)(false, 'showMorePagesIndicator', pageInfo),
    totalCount: totalCount,
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
};
exports.HttpQueryTabBody = HttpQueryTabBody;
HttpQueryTabBody.displayName = 'HttpQueryTabBody';