"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UncommonProcessQueryTabBody = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _uncommon_processes = require("../../containers/uncommon_processes");
var _uncommon_process_table = require("../../components/uncommon_process_table");
var _manage_query = require("../../../../common/components/page/manage_query");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/hosts/pages/navigation/uncommon_process_query_tab_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UncommonProcessTableManage = (0, _manage_query.manageQuery)(_uncommon_process_table.UncommonProcessTable);
const UncommonProcessQueryTabBody = ({
  deleteQuery,
  endDate,
  filterQuery,
  indexNames,
  skip,
  setQuery,
  startDate,
  type
}) => {
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(_uncommon_processes.ID);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const [loading, {
    uncommonProcesses,
    totalCount,
    pageInfo,
    loadPage,
    id,
    inspect,
    isInspected,
    refetch
  }] = (0, _uncommon_processes.useUncommonProcesses)({
    endDate,
    filterQuery,
    indexNames,
    skip: querySkip,
    startDate,
    type
  });
  return /*#__PURE__*/_react.default.createElement(UncommonProcessTableManage, {
    deleteQuery: deleteQuery,
    data: uncommonProcesses,
    fakeTotalCount: (0, _fp.getOr)(50, 'fakeTotalCount', pageInfo),
    id: id,
    inspect: inspect,
    isInspect: isInspected,
    loading: loading,
    loadPage: loadPage,
    refetch: refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: (0, _fp.getOr)(false, 'showMorePagesIndicator', pageInfo),
    totalCount: totalCount,
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  });
};
exports.UncommonProcessQueryTabBody = UncommonProcessQueryTabBody;
UncommonProcessQueryTabBody.displayName = 'UncommonProcessQueryTabBody';