"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Hosts = void 0;
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/timelines-plugin/public");
var _common = require("@kbn/data-plugin/common");
var _common2 = require("@kbn/timelines-plugin/common");
var _constants = require("../../../data_view_manager/constants");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _constants2 = require("../../../common/store/inputs/constants");
var _types = require("../../../app/types");
var _filters_global = require("../../../common/components/filters_global");
var _header_page = require("../../../common/components/header_page");
var _last_event_time = require("../../../common/components/last_event_time");
var _has_ml_user_permissions = require("../../../../common/machine_learning/has_ml_user_permissions");
var _tab_navigation = require("../../../common/components/navigation/tab_navigation");
var _kpi_hosts = require("../components/kpi_hosts");
var _search_bar = require("../../../common/components/search_bar");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _use_global_time = require("../../../common/containers/use_global_time");
var _types2 = require("../../../../common/entity_analytics/types");
var _kibana = require("../../../common/lib/kibana");
var _kuery = require("../../../common/lib/kuery");
var _store = require("../../../common/store");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _display = require("./display");
var _hosts_tabs = require("./hosts_tabs");
var _nav_tabs = require("./nav_tabs");
var i18n = _interopRequireWildcard(require("./translations"));
var _store2 = require("../store");
var _helpers = require("../store/helpers");
var _model = require("../store/model");
var _helpers2 = require("../../../timelines/components/timeline/helpers");
var _containers = require("../../../sourcerer/containers");
var _use_selector = require("../../../common/hooks/use_selector");
var _use_invalid_filter_query = require("../../../common/hooks/use_invalid_filter_query");
var _hosts = require("../containers/hosts");
var _empty_prompt = require("../../../common/components/empty_prompt");
var _utils = require("../../../common/components/visualization_actions/utils");
var _use_license = require("../../../common/hooks/use_license");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _use_selected_patterns = require("../../../data_view_manager/hooks/use_selected_patterns");
var _page_loader = require("../../../common/components/page_loader");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/hosts/pages/hosts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Need a 100% height here to account for the graph/analyze tool, which sets no explicit height parameters, but fills the available space.
 */
const StyledFullHeightContainer = _styled.default.div`
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
`;
const HostsComponent = () => {
  const containerElement = (0, _react.useRef)(null);
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const getHostRiskScoreFilterQuerySelector = (0, _react.useMemo)(() => _store2.hostsSelectors.hostRiskScoreSeverityFilterSelector(), []);
  const severitySelection = (0, _use_selector.useDeepEqualSelector)(state => getHostRiskScoreFilterQuerySelector(state, _store2.hostsModel.HostsType.page));
  const {
    to,
    from,
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const {
    tabName
  } = (0, _reactRouterDom.useParams)();
  const tabsFilters = _react.default.useMemo(() => {
    const hostNameExistsFilter = (0, _utils.fieldNameExistsFilter)(_types.SecurityPageName.hosts);
    if (tabName === _model.HostsTableType.events) {
      return [...globalFilters, ...hostNameExistsFilter];
    }
    if (tabName === _model.HostsTableType.risk) {
      const severityFilter = (0, _helpers.generateSeverityFilter)(severitySelection, _types2.EntityType.host);
      return [...globalFilters, ...hostNameExistsFilter, ...severityFilter];
    }
    return globalFilters;
  }, [globalFilters, severitySelection, tabName]);
  const {
    indicesExist: oldIndicesExist,
    selectedPatterns: oldSelectedPatterns,
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(_constants.DataViewManagerScopeName.explore);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_constants.DataViewManagerScopeName.explore);
  const indicesExist = newDataViewPickerEnabled ? experimentalDataView.hasMatchedIndices() : oldIndicesExist;
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const [globalFilterQuery, kqlError] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    dataViewSpec: oldSourcererDataView,
    dataView: experimentalDataView,
    queries: [query],
    filters: globalFilters
  }), [uiSettings, oldSourcererDataView, experimentalDataView, query, globalFilters]);
  const [tabsFilterQuery] = (0, _react.useMemo)(() => (0, _kuery.convertToBuildEsQuery)({
    config: (0, _common.getEsQueryConfig)(uiSettings),
    dataViewSpec: oldSourcererDataView,
    dataView: experimentalDataView,
    queries: [query],
    filters: tabsFilters
  }), [uiSettings, oldSourcererDataView, experimentalDataView, query, tabsFilters]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: _hosts.ID,
    filterQuery: globalFilterQuery,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    var _containerElement$cur, _containerElement$cur2;
    (_containerElement$cur = containerElement.current) === null || _containerElement$cur === void 0 ? void 0 : (_containerElement$cur2 = _containerElement$cur.querySelector('.inspectButtonComponent:last-of-type')) === null || _containerElement$cur2 === void 0 ? void 0 : _containerElement$cur2.focus();
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers2.resetKeyboardFocus)();
  }, []);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers2.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(StyledFullHeightContainer, {
    onKeyDown: onKeyDown,
    ref: containerElement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants2.InputsModelId.global,
    sourcererDataView: newDataViewPickerEnabled ? experimentalDataView : oldSourcererDataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    subtitle: /*#__PURE__*/_react.default.createElement(_last_event_time.LastEventTime, {
      indexKey: _common2.LastEventIndexKey.hosts,
      indexNames: selectedPatterns,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 19
      }
    }),
    title: i18n.PAGE_TITLE,
    border: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_kpi_hosts.HostsKpiComponent, {
    from: from,
    to: to,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: (0, _nav_tabs.navTabsHosts)({
      hasMlUserPermissions: (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities),
      isEnterprise: isEnterprisePlus
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_hosts_tabs.HostsTabs, {
    deleteQuery: deleteQuery,
    to: to,
    filterQuery: tabsFilterQuery,
    isInitializing: isInitializing,
    indexNames: selectedPatterns,
    setQuery: setQuery,
    from: from,
    type: _store2.hostsModel.HostsType.page,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.hosts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }));
};
HostsComponent.displayName = 'HostsComponent';
const Hosts = exports.Hosts = /*#__PURE__*/_react.default.memo(HostsComponent);