"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _sort = require("../../../../../common/api/search_strategy/hosts/model/sort");
var _paginated_table = require("../../../components/paginated_table");
var _use_selector = require("../../../../common/hooks/use_selector");
var _store = require("../../store");
var _columns = require("./columns");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../../../common/constants");
var _model = require("../../store/model");
var _hooks = require("../../../../common/lib/kibana/hooks");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _helper_hooks = require("../../../../helper_hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/hosts/components/hosts_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tableType = _store.hostsModel.HostsTableType.hosts;
const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const getSorting = (sortField, direction) => ({
  field: getNodeField(sortField),
  direction
});
const HostsTableComponent = ({
  data,
  fakeTotalCount,
  id,
  isInspect,
  loading,
  loadPage,
  setQuerySkip,
  showMorePagesIndicator,
  totalCount,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    navigateTo
  } = (0, _hooks.useNavigateTo)();
  const getHostsSelector = (0, _react.useMemo)(() => _store.hostsSelectors.hostsSelector(), []);
  const {
    activePage,
    direction,
    limit,
    sortField
  } = (0, _use_selector.useDeepEqualSelector)(state => getHostsSelector(state, type));
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.hostsActions.updateTableLimit({
    hostsType: type,
    limit: newLimit,
    tableType
  })), [type, dispatch]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.hostsActions.updateTableActivePage({
    activePage: newPage,
    hostsType: type,
    tableType
  })), [type, dispatch]);
  const onChange = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null) {
      const sort = {
        field: getSortField(criteria.sort.field),
        direction: criteria.sort.direction
      };
      if (sort.direction !== direction || sort.field !== sortField) {
        dispatch(_store.hostsActions.updateHostsSort({
          sort,
          hostsType: type
        }));
      }
    }
  }, [direction, sortField, type, dispatch]);
  const hasEntityAnalyticsCapability = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  const isPlatinumOrTrialLicense = (0, _use_ml_capabilities.useMlCapabilities)().isPlatinumOrTrialLicense;
  const dispatchSeverityUpdate = (0, _react.useCallback)(s => {
    dispatch(_store.hostsActions.updateHostRiskScoreSeverityFilter({
      severitySelection: [s],
      hostsType: type
    }));
    navigateTo({
      deepLinkId: _constants.SecurityPageName.hosts,
      path: _model.HostsTableType.risk
    });
  }, [dispatch, navigateTo, type]);
  const hostsColumns = (0, _react.useMemo)(() => (0, _columns.getHostsColumns)(isPlatinumOrTrialLicense && hasEntityAnalyticsCapability, dispatchSeverityUpdate), [dispatchSeverityUpdate, isPlatinumOrTrialLicense, hasEntityAnalyticsCapability]);
  const sorting = (0, _react.useMemo)(() => getSorting(sortField, direction), [sortField, direction]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: hostsColumns,
    dataTestSubj: `table-${tableType}`,
    headerCount: totalCount,
    headerTitle: i18n.HOSTS,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    isInspect: isInspect,
    itemsPerRow: rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    onChange: onChange,
    pageOfItems: data,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: showMorePagesIndicator,
    sorting: sorting,
    totalCount: fakeTotalCount,
    updateLimitPagination: updateLimitPagination,
    updateActivePage: updateActivePage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 5
    }
  });
};
HostsTableComponent.displayName = 'HostsTableComponent';
const getSortField = field => {
  switch (field) {
    case 'node.host.name':
      return _sort.HostsFields.hostName;
    case 'node.lastSeen':
      return _sort.HostsFields.lastSeen;
    default:
      return _sort.HostsFields.lastSeen;
  }
};
const getNodeField = field => {
  switch (field) {
    case _sort.HostsFields.hostName:
      return 'node.host.name';
    case _sort.HostsFields.lastSeen:
      return 'node.lastSeen';
    default:
      return '';
  }
};
const HostsTable = exports.HostsTable = /*#__PURE__*/_react.default.memo(HostsTableComponent);
HostsTable.displayName = 'HostsTable';