"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationCards = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/fleet-plugin/public");
var _react2 = require("@emotion/react");
var _constants = require("../../../../common/lib/integrations/constants");
var _use_integration_link_state = require("../../../../common/hooks/integrations/use_integration_link_state");
var _integrations = require("../../../../common/utils/integrations");
var _constants2 = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var _use_integrations = require("../hooks/use_integrations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring_onboarding/components/integrations_cards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This component has to be wrapped by react Suspense.
 * It suspends while loading the lazy package card and while fetching the integrations.
 */
const IntegrationCards = ({
  onIntegrationInstalled,
  maxCardWidth,
  showInstallationStatus = false,
  titleSize = 's'
}) => {
  const state = (0, _use_integration_link_state.useIntegrationLinkState)(_constants2.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH);
  const {
    navigateTo
  } = (0, _kibana.useNavigation)();
  const integrations = (0, _use_integrations.useEntityAnalyticsIntegrations)();
  const navigateToIntegration = (0, _react.useCallback)((id, version) => {
    navigateTo({
      appId: _constants.INTEGRATION_APP_ID,
      path: (0, _integrations.addPathParamToUrl)(`/detail/${id}-${version}/overview`, _constants2.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH, {
        prerelease: 'true'
      } // entityanalytics_ad is a technical preview package, delete this line when it is GA
      ),
      state
    });
  }, [navigateTo, state]);
  (0, _react.useEffect)(() => {
    const installedIntegrations = integrations.filter(({
      status
    }) => status === 'installed');
    if (installedIntegrations.length > 0) {
      onIntegrationInstalled === null || onIntegrationInstalled === void 0 ? void 0 : onIntegrationInstalled(0); // We can't provide the number of users installed at this point because the integration run async.
    }
  }, [integrations, onIntegrationInstalled]);
  const hasInstallationStatus = integrations.some(({
    status
  }) => status === 'installing' || status === 'install_failed' || status === 'installed');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, integrations.map(({
    name,
    title,
    icons,
    description,
    version,
    status
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: maxCardWidth ? 0 : 1,
    key: name,
    "data-test-subj": "entity_analytics-integration-card",
    css: (0, _react2.css)`
            max-width: ${maxCardWidth}px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.LazyPackageCard, {
    description: description !== null && description !== void 0 ? description : '',
    icons: icons !== null && icons !== void 0 ? icons : [],
    minCardHeight: showInstallationStatus && hasInstallationStatus ? 144 : 84,
    descriptionLineClamp: 2,
    titleLineClamp: 1,
    id: name,
    name: name,
    title: title,
    titleSize: titleSize,
    version: version,
    onCardClick: () => {
      navigateToIntegration(name, version);
    }
    // Required values that don't make sense for this scenario
    ,
    categories: [],
    integration: '',
    url: '',
    installStatus: status === 'not_installed' ? undefined : status,
    showInstallationStatus: showInstallationStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }))));
};
exports.IntegrationCards = IntegrationCards;