"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_HOSTS_BY_SEVERITY = exports.LAST_UPDATED = exports.HOST_RISK_TITLE = exports.HOST_RISK_SCORE = exports.HOST_RISK = exports.HOST_NAME = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_NAME = exports.HOST_NAME = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.hostNameTitle', {
  defaultMessage: 'Host Name'
});
const HOST_RISK_SCORE = exports.HOST_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.hostRiskScoreTitle', {
  defaultMessage: 'Host risk score'
});
const HOST_RISK = exports.HOST_RISK = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.riskTitle', {
  defaultMessage: 'Host risk level'
});
const HOST_RISK_TITLE = exports.HOST_RISK_TITLE = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.hostRiskTitle', {
  defaultMessage: 'Host risk'
});
const VIEW_HOSTS_BY_SEVERITY = severity => _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.filteredHostsTitle', {
  values: {
    severity
  },
  defaultMessage: 'View {severity} risk hosts'
});
exports.VIEW_HOSTS_BY_SEVERITY = VIEW_HOSTS_BY_SEVERITY;
const LAST_UPDATED = exports.LAST_UPDATED = _i18n.i18n.translate('xpack.securitySolution.hostsRiskTable.lastUpdatedTitle', {
  defaultMessage: 'Last updated'
});