"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomaliesCountLink = void 0;
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _use_anomalies_search = require("../../../common/components/ml/anomaly/use_anomalies_search");
var _links = require("../../../common/components/links");
var _types = require("../../../app/types");
var _store = require("../../../explore/users/store");
var _store2 = require("../../../explore/hosts/store");
var _model = require("../../../explore/hosts/store/model");
var _model2 = require("../../../explore/users/store/model");
var _kibana = require("../../../common/lib/kibana");
var _telemetry = require("../../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_analytics_anomalies/anomalies_count_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomaliesCountLink = ({
  count,
  jobId,
  entity
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const deepLinkId = entity === _use_anomalies_search.AnomalyEntity.User ? _types.SecurityPageName.usersAnomalies : _types.SecurityPageName.hostsAnomalies;
  const onClick = (0, _react.useCallback)(() => {
    if (!jobId) return;
    telemetry.reportEvent(_telemetry.EntityEventTypes.AnomaliesCountClicked, {
      jobId,
      count
    });
    if (entity === _use_anomalies_search.AnomalyEntity.User) {
      dispatch(_store.usersActions.updateUsersAnomaliesJobIdFilter({
        jobIds: [jobId],
        usersType: _model2.UsersType.page
      }));
      dispatch(_store.usersActions.updateUsersAnomaliesInterval({
        interval: 'second',
        usersType: _model2.UsersType.page
      }));
    } else {
      dispatch(_store2.hostsActions.updateHostsAnomaliesJobIdFilter({
        jobIds: [jobId],
        hostsType: _model.HostsType.page
      }));
      dispatch(_store2.hostsActions.updateHostsAnomaliesInterval({
        interval: 'second',
        hostsType: _model.HostsType.page
      }));
    }
  }, [jobId, telemetry, count, entity, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
    onClick: onClick,
    deepLinkId: deepLinkId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, count);
};
exports.AnomaliesCountLink = AnomaliesCountLink;