"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsProgressBarPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _header_section = require("../../../../common/components/header_section");
var _inspect = require("../../../../common/components/inspect");
var _components = require("../common/components");
var _alerts_progress_bar = require("./alerts_progress_bar");
var _use_summary_chart_data = require("../alerts_summary_charts_panel/use_summary_chart_data");
var _aggregations = require("../alerts_summary_charts_panel/aggregations");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/alerts_progress_bar_panel/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TOP_ALERTS_CHART_ID = 'alerts-summary-top-alerts';
const DEFAULT_COMBOBOX_WIDTH = 150;
const DEFAULT_OPTIONS = ['host.name', 'user.name', 'source.ip', 'destination.ip'];
/**
 * Renders a list showing the percentages of alerts grouped by a property.
 * The component is used in the alerts page, where users can select what fields they want the alerts to be grouped by,
 * and in the AI for SOC alert summary page where the alerts are automatically grouped by host.
 */
const AlertsProgressBarPanel = ({
  filters,
  query,
  signalIndexName,
  runtimeMappings,
  skip,
  groupBySelection,
  setGroupBySelection,
  addFilter
}) => {
  const uniqueQueryId = (0, _react.useMemo)(() => `${TOP_ALERTS_CHART_ID}-${(0, _uuid.v4)()}`, []);
  const dropDownOptions = DEFAULT_OPTIONS.map(field => {
    return {
      value: field,
      label: field
    };
  });
  const aggregations = (0, _react.useMemo)(() => (0, _aggregations.alertsGroupingAggregations)(groupBySelection), [groupBySelection]);
  const onSelect = (0, _react.useCallback)(field => {
    setGroupBySelection(field);
  }, [setGroupBySelection]);
  const {
    items,
    isLoading
  } = (0, _use_summary_chart_data.useSummaryChartData)({
    aggregations,
    filters,
    query,
    signalIndexName,
    runtimeMappings,
    skip,
    uniqueQueryId
  });
  const data = (0, _react.useMemo)(() => (0, _helpers.getIsAlertsProgressBarData)(items) ? items : [], [items]);
  const inspectTitle = (0, _react.useMemo)(() => `${i18n.ALERT_BY_TITLE} ${groupBySelection}`, [groupBySelection]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": "alerts-progress-bar-panel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: uniqueQueryId,
    inspectTitle: inspectTitle,
    outerDirection: "row",
    title: i18n.ALERT_BY_TITLE,
    titleSize: "xs",
    hideSubtitle: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_components.StackByComboBox, {
    "data-test-subj": "stackByComboBox",
    selected: groupBySelection,
    onSelect: onSelect,
    prepend: '',
    width: DEFAULT_COMBOBOX_WIDTH,
    dropDownoptions: dropDownOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_alerts_progress_bar.AlertsProgressBar, {
    data: data,
    isLoading: isLoading,
    groupBySelection: groupBySelection,
    addFilter: addFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  })));
};
exports.AlertsProgressBarPanel = AlertsProgressBarPanel;
AlertsProgressBarPanel.displayName = 'AlertsProgressBarPanel';