"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleActivityFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/pages/coverage_overview/rule_activity_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleActivityFilterComponent = ({
  selected,
  onChange,
  isLoading
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen]);
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const numActiveFilters = (0, _react.useMemo)(() => selected.length, [selected]);
  const options = (0, _helpers.populateSelected)(_constants.ruleActivityFilterDefaultOptions, selected);
  const handleSelectableOnChange = (0, _react.useCallback)(newOptions => {
    const formattedOptions = (0, _helpers.extractSelected)(newOptions);
    onChange(formattedOptions);
  }, [onChange]);
  const handleOnClear = (0, _react.useCallback)(() => {
    onChange([]);
  }, [onChange]);
  const renderOptionLabel = option => _constants.ruleActivityFilterLabelMap[option.label];
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": "coverageOverviewRuleActivityFilterButton",
    isLoading: isLoading,
    iconType: "arrowDown",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    hasActiveFilters: numActiveFilters > 0,
    numActiveFilters: numActiveFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, i18n.CoverageOverviewRuleActivityFilterLabel), [isPopoverOpen, numActiveFilters, onButtonClick, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    css: (0, _css.css)`
        width: ${_constants.coverageOverviewFilterWidth}px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "ruleActivityFilterPopover",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, i18n.CoverageOverviewFilterPopoverTitle), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": "coverageOverviewFilterList",
    options: options,
    onChange: handleSelectableOnChange,
    renderOption: renderOptionLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _css.css)`
                width: ${_constants.coverageOverviewFilterWidth}px;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, list)), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    paddingSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    css: (0, _css.css)`
              width: 100%;
            `,
    iconType: "cross",
    color: "danger",
    size: "xs",
    isDisabled: numActiveFilters === 0,
    onClick: handleOnClear,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, i18n.CoverageOverviewFilterPopoverClearAll))));
};
const RuleActivityFilter = exports.RuleActivityFilter = /*#__PURE__*/_react.default.memo(RuleActivityFilterComponent);